/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.vdldoc;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VdldocGenerator {
    private static final String RESOURCE_PATH = "/org/omnifaces/vdldoc/resources";
    private static final String DEFAULT_WINDOW_TITLE = "VDL Documentation Generator - Generated Documentation";
    private static final String DEFAULT_DOC_TITLE = "VDL Documentation Generator - Generated Documentation";
    private static final String NS_JAVAEE = "http://java.sun.com/xml/ns/javaee";
    private static final boolean DEBUG_INPUT_DOCUMENT = false;
    private static final String ERROR_JAVAEE_MISSING = "%s does not have xmlns=\"http://java.sun.com/xml/ns/javaee\"";
    private static final String ERROR_TAGLIB_MISSING = "%s does not have <facelet-taglib> as root.";
    private static final String WARNING_ID_MISSING = "WARNING: %s does not have <facelet-taglib id> attribute. Defaulting to base filename '%s'... ";
    private static final String ERROR_DUPLICATE_ID = "Two tag libraries exist with the same <facelet-taglib id> attribute '%s'. This is not supported.";
    private List<File> taglibs = new ArrayList<File>();
    private File outputDirectory = new File("vdldoc");
    private String windowTitle = "VDL Documentation Generator - Generated Documentation";
    private String docTitle = "VDL Documentation Generator - Generated Documentation";
    private boolean quiet;
    private Document summary;

    public void addTaglib(File taglib) {
        this.taglibs.add(taglib);
    }

    public void setOutputDirectory(File dir) {
        this.outputDirectory = dir;
    }

    public void setWindowTitle(String title) {
        this.windowTitle = title;
    }

    public void setDocTitle(String title) {
        this.docTitle = title;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void generate() throws IllegalArgumentException {
        try {
            this.createSummaryDoc();
            this.copyStaticFiles();
            this.generateOverview();
            this.generateTaglibDetail();
            this.println("VDL documentation generation is finished!");
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void createSummaryDoc() throws IOException, SAXException, ParserConfigurationException, TransformerException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new CharArrayReader(new char[0]));
            }
        });
        this.summary = documentBuilder.newDocument();
        Element rootElement = this.summary.createElementNS(NS_JAVAEE, "facelet-taglibs");
        this.summary.appendChild(rootElement);
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NS_JAVAEE);
        Element configElement = this.summary.createElementNS(NS_JAVAEE, "config");
        rootElement.appendChild(configElement);
        Element windowTitle = this.summary.createElementNS(NS_JAVAEE, "window-title");
        windowTitle.appendChild(this.summary.createTextNode(this.windowTitle));
        configElement.appendChild(windowTitle);
        Element docTitle = this.summary.createElementNS(NS_JAVAEE, "doc-title");
        docTitle.appendChild(this.summary.createTextNode(this.docTitle));
        configElement.appendChild(docTitle);
        this.print("Parsing " + this.taglibs.size() + " taglib files... ");
        for (File taglib : this.taglibs) {
            Document doc;
            FileInputStream in = new FileInputStream(taglib);
            try {
                doc = documentBuilder.parse(new InputSource(in));
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            int numTags = doc.getDocumentElement().getElementsByTagNameNS("*", "tag").getLength() + doc.getDocumentElement().getElementsByTagNameNS("*", "function").getLength();
            if (numTags <= 0) continue;
            Element taglibNode = (Element)this.summary.importNode(doc.getDocumentElement(), true);
            if (!taglibNode.getNamespaceURI().equals(NS_JAVAEE)) {
                throw new IllegalArgumentException(String.format(ERROR_JAVAEE_MISSING, taglib.getName()));
            }
            if (!taglibNode.getLocalName().equals("facelet-taglib")) {
                throw new IllegalArgumentException(String.format(ERROR_TAGLIB_MISSING, taglib.getName()));
            }
            String id = taglibNode.getAttribute("id");
            if (id == null || id.trim().isEmpty()) {
                id = taglib.getName().substring(0, taglib.getName().indexOf(46));
                taglibNode.setAttribute("id", taglib.getName().substring(0, taglib.getName().indexOf(46)));
                this.print(String.format(WARNING_ID_MISSING, taglib.getName(), id));
            }
            rootElement.appendChild(taglibNode);
        }
        this.println("OK!");
    }

    private void copyStaticFiles() throws IOException {
        this.print("Copying static files... ");
        this.outputDirectory.mkdirs();
        VdldocGenerator.copyResourceToFile("stylesheet.css", this.outputDirectory);
        File outputResourceDirectory = new File(this.outputDirectory, "resources");
        outputResourceDirectory.mkdirs();
        VdldocGenerator.copyResourceToFile("background.gif", outputResourceDirectory);
        VdldocGenerator.copyResourceToFile("tab.gif", outputResourceDirectory);
        VdldocGenerator.copyResourceToFile("titlebar_end.gif", outputResourceDirectory);
        VdldocGenerator.copyResourceToFile("titlebar.gif", outputResourceDirectory);
        this.println("OK!");
    }

    private void generateOverview() throws TransformerException {
        this.print("Generating overview pages... ");
        this.generatePage(new File(this.outputDirectory, "index.html"), "index.html.xsl");
        this.generatePage(new File(this.outputDirectory, "help-doc.html"), "help-doc.html.xsl");
        this.generatePage(new File(this.outputDirectory, "overview-frame.html"), "overview-frame.html.xsl");
        this.generatePage(new File(this.outputDirectory, "alltags-frame.html"), "alltags-frame.html.xsl");
        this.generatePage(new File(this.outputDirectory, "alltags-noframe.html"), "alltags-noframe.html.xsl");
        this.generatePage(new File(this.outputDirectory, "overview-summary.html"), "overview-summary.html.xsl");
        this.println("OK!");
    }

    private void generateTaglibDetail() throws IllegalArgumentException, TransformerException {
        HashSet<String> ids = new HashSet<String>();
        Element root = this.summary.getDocumentElement();
        NodeList taglibs = root.getElementsByTagNameNS("*", "facelet-taglib");
        int size = taglibs.getLength();
        int i = 0;
        while (i < size) {
            Element taglib = (Element)taglibs.item(i);
            String id = taglib.getAttribute("id");
            if (!ids.add(id)) {
                throw new IllegalArgumentException(String.format(ERROR_DUPLICATE_ID, id));
            }
            this.print("Generating docs for taglib '" + id + "'... ");
            File outputDirectory = new File(this.outputDirectory, id);
            outputDirectory.mkdir();
            this.generateTaglibDetail(outputDirectory, id);
            NodeList tags = taglib.getElementsByTagNameNS("*", "tag");
            int numTags = tags.getLength();
            int j = 0;
            while (j < numTags) {
                Element tag = (Element)tags.item(j);
                String tagName = VdldocGenerator.findElementValue(tag, "tag-name");
                this.generateTagDetail(outputDirectory, id, tagName);
                ++j;
            }
            NodeList functions = taglib.getElementsByTagNameNS("*", "function");
            int numFunctions = functions.getLength();
            int j2 = 0;
            while (j2 < numFunctions) {
                Element function = (Element)functions.item(j2);
                String functionName = VdldocGenerator.findElementValue(function, "function-name");
                this.generateFunctionDetail(outputDirectory, id, functionName);
                ++j2;
            }
            this.println("OK!");
            ++i;
        }
    }

    private void generateTaglibDetail(File outputDirectory, String id) throws TransformerException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        this.generatePage(new File(outputDirectory, "tld-frame.html"), "tld-frame.html.xsl", parameters);
        this.generatePage(new File(outputDirectory, "tld-summary.html"), "tld-summary.html.xsl", parameters);
    }

    private void generateTagDetail(File outputDirectory, String id, String tagName) throws TransformerException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        parameters.put("tagName", tagName);
        this.generatePage(new File(outputDirectory, String.valueOf(tagName) + ".html"), "tag.html.xsl", parameters);
    }

    private void generateFunctionDetail(File outputDirectory, String id, String functionName) throws TransformerException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        parameters.put("functionName", functionName);
        this.generatePage(new File(outputDirectory, String.valueOf(functionName) + ".fn.html"), "function.html.xsl", parameters);
    }

    private void generatePage(File outputFile, String inputXSL) throws TransformerException {
        this.generatePage(outputFile, inputXSL, Collections.<String, String>emptyMap());
    }

    private void generatePage(File outputFile, String inputXSL, Map<String, String> params) throws TransformerException {
        InputStream xsl = VdldocGenerator.getResourceAsStream(inputXSL);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xsl));
        for (Map.Entry<String, String> entry : params.entrySet()) {
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
        transformer.transform(new DOMSource(this.summary), new StreamResult(outputFile));
    }

    private static String findElementValue(Element parent, String tagName) {
        Element child;
        Node body;
        String result = null;
        NodeList elements = parent.getElementsByTagNameNS("*", tagName);
        if (elements.getLength() >= 1 && (body = (child = (Element)elements.item(0)).getFirstChild()).getNodeType() == 3) {
            result = body.getNodeValue();
        }
        return result;
    }

    private static void copyResourceToFile(String resourceName, File outputDirectory) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = VdldocGenerator.getResourceAsStream(resourceName);
            out = new FileOutputStream(new File(outputDirectory, resourceName));
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static InputStream getResourceAsStream(String resourceName) {
        return VdldocGenerator.class.getResourceAsStream("/org/omnifaces/vdldoc/resources/" + resourceName);
    }

    private void print(String message) {
        if (!this.quiet) {
            System.out.print(message);
        }
    }

    private void println(String message) {
        if (!this.quiet) {
            System.out.println(message);
        }
    }
}

