# How to contribute

Community contributions are essential for maintaining the vitality of the RichFaces Project.
Contributing to the project helps to deliver functionality you need and allows you to share your code with other contributors and users. 
We want to keep it as easy as possible to contribute your changes and we will work hard to deliver your contributions in an upcoming release.
There are a few guidelines that we need contributors to follow to enable us to manage the process.

## Getting Started

* Follow the instructions in the [Contributor Getting Started Guide](https://community.jboss.org/wiki/ContributorGettingStartedGuide)
* Check-list:
    * Make sure you have a [JBoss account](http://github.com/)
    * Make sure you have a [GitHub account](http://github.com/)
    * Submit an [issue report](https://issues.jboss.org/browse/RF), assuming one does not already exist.
        * [Clearly describe the issue](https://community.jboss.org/wiki/SubmittingEffectiveIssueReports) including steps to reproduce when it is a bug.
        * Make sure you fill in the earliest version that you know has the issue.
* Fork the RichFaces repository on GitHub

## Making Changes

* Follow:
    * the [First-Time Contributor Workflow](https://community.jboss.org/wiki/RichFacesGitWorkflowModel#FirstTime_Contributor_Workflow)
    * and then the [Contributor Workflow](https://community.jboss.org/wiki/RichFacesGitWorkflowModel#Contributor_Workflow)

Make sure the code is [properly formatted](https://community.jboss.org/wiki/ImportFormattingRules).  A common mistake is changing the original line-endings (DOS/unix).  Make sure the patch can be cleanly applied (particular line changes are clearly visible when using `git diff HEAD^` or in GitHub commits history)

## Submitting Changes

* Sign the [Contributor License Agreement](http://cla.jboss.org/) for **RichFaces** project.
* Submit a [pull request](https://help.github.com/articles/creating-a-pull-request)
    * Follow the project's [Guide to use pull requests with GitHub and JIRA](https://community.jboss.org/wiki/GuideToUsePullRequestsWithGitHubAndJIRA)

# Additional Resources

* [More information on contributing](https://community.jboss.org/wiki/ContributorGettingStartedGuide)
* [Bug tracker (JIRA)](https://issues.jboss.org/browse/RF)
* [Contributor License Agreement](http://cla.jboss.org/)
* [General GitHub documentation](http://help.github.com/)
* [GitHub pull request documentation](http://help.github.com/send-pull-requests/)
* #richfaces IRC channel on irc.freenode.org
