/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.plugin;

import java.util.Locale;
import org.apache.maven.plugin.logging.Log;
import org.richfaces.l10n.BundleLoader;
import org.richfaces.l10n.InterpolationException;
import org.richfaces.l10n.MessageInterpolator;
import org.richfaces.log.Logger;

public class LoggerWrapper
implements Logger {
    private MessageInterpolator messageInterpolator;
    private Log log;

    public LoggerWrapper(Log log) {
        this.log = log;
        this.messageInterpolator = new MessageInterpolator(new BundleLoader());
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(CharSequence content) {
        this.log(Logger.Level.DEBUG, content);
    }

    public void debug(Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.DEBUG, messageKey, args);
    }

    public void debug(CharSequence content, Throwable thrown) {
        this.log(Logger.Level.DEBUG, content, thrown);
    }

    public void debug(Throwable error, Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.DEBUG, error, messageKey, args);
    }

    public void debug(Throwable thrown) {
        this.log(Logger.Level.DEBUG, thrown);
    }

    public boolean isInfoEnabled() {
        return this.isLogEnabled(Logger.Level.INFO);
    }

    public void info(CharSequence content) {
        this.log(Logger.Level.INFO, content);
    }

    public void info(Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.INFO, messageKey, args);
    }

    public void info(CharSequence content, Throwable thrown) {
        this.log(Logger.Level.INFO, content, thrown);
    }

    public void info(Throwable error, Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.INFO, error, messageKey, args);
    }

    public void info(Throwable thrown) {
        this.log(Logger.Level.INFO, thrown);
    }

    public boolean isWarnEnabled() {
        return this.isLogEnabled(Logger.Level.WARNING);
    }

    public void warn(CharSequence content) {
        this.log(Logger.Level.WARNING, content);
    }

    public void warn(Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.WARNING, messageKey, args);
    }

    public void warn(CharSequence content, Throwable thrown) {
        this.log(Logger.Level.WARNING, content, thrown);
    }

    public void warn(Throwable error, Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.WARNING, error, messageKey, args);
    }

    public void warn(Throwable thrown) {
        this.log(Logger.Level.WARNING, thrown);
    }

    public boolean isErrorEnabled() {
        return this.isLogEnabled(Logger.Level.ERROR);
    }

    public void error(CharSequence content) {
        this.log(Logger.Level.ERROR, content);
    }

    public void error(Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.ERROR, messageKey, args);
    }

    public void error(CharSequence content, Throwable thrown) {
        this.log(Logger.Level.ERROR, content, thrown);
    }

    public void error(Throwable error, Enum<?> messageKey, Object ... args) {
        this.log(Logger.Level.ERROR, error, messageKey, args);
    }

    public void error(Throwable thrown) {
        this.log(Logger.Level.ERROR, thrown);
    }

    public boolean isLogEnabled(Logger.Level level) {
        switch (level) {
            case DEBUG: {
                return this.log.isDebugEnabled();
            }
            case INFO: {
                return this.log.isInfoEnabled();
            }
            case WARNING: {
                return this.log.isWarnEnabled();
            }
            case ERROR: {
                return this.log.isErrorEnabled();
            }
        }
        throw new IllegalStateException("Unknown Logger Level");
    }

    public void log(Logger.Level level, CharSequence content) {
        if (this.isLogEnabled(level)) {
            switch (level) {
                case DEBUG: {
                    this.log.debug(content);
                    break;
                }
                case INFO: {
                    this.log.info(content);
                    break;
                }
                case WARNING: {
                    this.log.warn(content);
                    break;
                }
                case ERROR: {
                    this.log.error(content);
                }
            }
        }
    }

    public void log(Logger.Level level, Enum<?> messageKey, Object ... args) {
        this.log(level, this.interpolate(messageKey, args));
    }

    public void log(Logger.Level level, CharSequence content, Throwable thrown) {
        if (this.isLogEnabled(level)) {
            switch (level) {
                case DEBUG: {
                    this.log.debug(content, thrown);
                    break;
                }
                case INFO: {
                    this.log.info(content, thrown);
                    break;
                }
                case WARNING: {
                    this.log.warn(content, thrown);
                    break;
                }
                case ERROR: {
                    this.log.error(content, thrown);
                }
            }
        }
    }

    public void log(Logger.Level level, Throwable thrown, Enum<?> messageKey, Object ... args) {
        this.log(level, this.interpolate(messageKey, args), thrown);
    }

    public void log(Logger.Level level, Throwable thrown) {
        if (this.isLogEnabled(level)) {
            switch (level) {
                case DEBUG: {
                    this.log.debug(thrown);
                    break;
                }
                case INFO: {
                    this.log.info(thrown);
                    break;
                }
                case WARNING: {
                    this.log.warn(thrown);
                    break;
                }
                case ERROR: {
                    this.log.error(thrown);
                }
            }
        }
    }

    private String interpolate(Enum<?> messageKey, Object ... args) {
        try {
            return this.messageInterpolator.interpolate(Locale.getDefault(), messageKey, args);
        }
        catch (InterpolationException e) {
            return "???" + e.getMessageKey() + "???";
        }
    }
}

