/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.parser.antlr;

import java.io.IOException;
import java.io.InputStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.parser.ProtocolParser;
import org.scribble.protocol.parser.antlr.AnnotationProcessor;
import org.scribble.protocol.parser.antlr.ProtocolTreeAdaptor;
import org.scribble.protocol.parser.antlr.ScribbleProtocolLexer;
import org.scribble.protocol.parser.antlr.ScribbleProtocolParser;

public class ANTLRProtocolParser
implements ProtocolParser {
    private AnnotationProcessor m_annotationProcessor = null;

    public boolean isSupported(String sourceType) {
        return "spr".equals(sourceType);
    }

    public ProtocolModel parse(InputStream is, Journal journal, ProtocolContext context) throws IOException {
        ProtocolModel ret = null;
        try {
            byte[] b = new byte[is.available()];
            is.read(b);
            is.close();
            String document = new String(b);
            ScribbleProtocolLexer lex = new ScribbleProtocolLexer((CharStream)new ANTLRStringStream(document));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
            ScribbleProtocolParser parser = new ScribbleProtocolParser((TokenStream)tokens);
            ProtocolTreeAdaptor adaptor = new ProtocolTreeAdaptor(this.m_annotationProcessor, journal);
            adaptor.setParser(parser);
            parser.setDocument(document);
            parser.setTreeAdaptor(adaptor);
            parser.setJournal(journal);
            parser.description();
            if (!parser.isErrorOccurred()) {
                ret = adaptor.getProtocolModel();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void setAnnotationProcessor(AnnotationProcessor ap) {
        this.m_annotationProcessor = ap;
    }
}

