/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation.connectedness;

import java.util.Collections;
import java.util.List;
import java.util.PropertyResourceBundle;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.DefaultVisitor;

public class ConnectednessVisitor
extends DefaultVisitor {
    private Journal m_logger = null;

    public ConnectednessVisitor(Journal logger) {
        this.m_logger = logger;
    }

    public boolean start(Block block) {
        List precedingInitiator = null;
        List precedingFinal = null;
        for (int i = 0; i < block.size(); ++i) {
            if (precedingInitiator != null && precedingFinal != null && block.get(i).initiatorRoles().size() > 0 && Collections.disjoint(precedingInitiator, block.get(i).initiatorRoles()) && Collections.disjoint(precedingFinal, block.get(i).initiatorRoles())) {
                this.m_logger.error(PropertyResourceBundle.getBundle("org.scribble.protocol.validation.connectedness.Messages").getString("_ACTIVITY_NOT_CONNECTED"), null);
            }
            if (block.get(i).initiatorRoles().size() <= 0) continue;
            precedingInitiator = block.get(i).initiatorRoles();
            precedingFinal = block.get(i).finalRoles();
        }
        return true;
    }
}

