/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.List;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Choice
extends Activity {
    private Role m_role = null;
    private List<Block> m_blocks = new ContainmentList<Block>(this, Block.class);

    public Role getRole() {
        return this.m_role;
    }

    public void setRole(Role part) {
        this.m_role = part;
    }

    public List<Block> getBlocks() {
        return this.m_blocks;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.start(this);
        if (this.getRole() != null) {
            this.getRole().visit(visitor);
        }
        for (Block b : this.getBlocks()) {
            b.visit(visitor);
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Choice that = (Choice)o;
        return !(this.m_role == null ? that.m_role != null : !this.m_role.equals(that.m_role)) && ((Object)this.m_blocks).equals(that.m_blocks);
    }

    public int hashCode() {
        int result = ((Object)this.m_blocks).hashCode();
        result = 31 * result + (this.m_role != null ? this.m_role.hashCode() : 0);
        return result;
    }

    public String toString() {
        String result = "choice ";
        if (this.m_role != null) {
            result = result + "at " + this.m_role + " ";
        }
        for (Block b : this.m_blocks) {
            if (this.m_blocks.indexOf(b) > 0) {
                result = result + "or ";
            }
            result = result + b + "\n";
        }
        return result;
    }
}

