/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.DirectedChoice;
import org.scribble.protocol.model.Do;
import org.scribble.protocol.model.End;
import org.scribble.protocol.model.Include;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Interrupt;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.OnMessage;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.Parameter;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolImport;
import org.scribble.protocol.model.ProtocolImportList;
import org.scribble.protocol.model.RecBlock;
import org.scribble.protocol.model.Recursion;
import org.scribble.protocol.model.Repeat;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.model.Unordered;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleUtil {
    public static Set<Role> getDeclaredRoles(Block block) {
        final HashSet<Role> roles = new HashSet<Role>();
        block.visit(new DefaultVisitor(){

            protected void addRole(Role r) {
                if (r != null && !roles.contains(r)) {
                    roles.add(r);
                }
            }

            public void accept(Introduces elem) {
                for (Role r : elem.getRoles()) {
                    this.addRole(r);
                }
            }

            public boolean start(Protocol elem) {
                return false;
            }
        });
        return roles;
    }

    public static Protocol getEnclosingProtocol(Role role) {
        Protocol ret = null;
        if (role.getParent() instanceof Introduces) {
            ret = ((Introduces)role.getParent()).enclosingProtocol();
        } else if (role.getParent() instanceof ParameterDefinition && role.getParent().getParent() instanceof Protocol) {
            ret = (Protocol)role.getParent().getParent();
        }
        return ret;
    }

    public static Set<Role> getUsedRoles(final Activity act) {
        final HashSet<Role> roles = new HashSet<Role>();
        act.visit(new DefaultVisitor(){

            protected void addRole(Role r) {
                if (r != null && !roles.contains(r)) {
                    roles.add(r);
                }
            }

            public void accept(Interaction elem) {
                this.addRole(elem.getFromRole());
                for (Role r : elem.getToRoles()) {
                    this.addRole(r);
                }
            }

            public void accept(Include elem) {
                Set<Role> inscope = RoleUtil.getRolesInScope(elem);
                block0: for (Parameter p : elem.getParameters()) {
                    for (Role r : inscope) {
                        if (!r.getName().equals(p.getName())) continue;
                        this.addRole(r);
                        continue block0;
                    }
                }
            }

            public void accept(Run elem) {
                Set<Role> inscope = RoleUtil.getRolesInScope(elem);
                block0: for (Parameter p : elem.getParameters()) {
                    for (Role r : inscope) {
                        if (!r.getName().equals(p.getName())) continue;
                        this.addRole(r);
                        continue block0;
                    }
                }
            }

            public boolean start(Choice elem) {
                this.addRole(elem.getRole());
                return true;
            }

            public boolean start(DirectedChoice elem) {
                this.addRole(elem.getFromRole());
                for (Role r : elem.getToRoles()) {
                    this.addRole(r);
                }
                return true;
            }

            public boolean start(Protocol elem) {
                return elem == act;
            }
        });
        return roles;
    }

    public static Set<Role> getRolesInScope(Activity activity) {
        Protocol protocol;
        HashSet<Role> ret = new HashSet<Role>();
        if (activity != null && (protocol = activity.enclosingProtocol()) != null) {
            RoleLocator visitor = new RoleLocator(protocol, activity, ret);
            protocol.visit(visitor);
        }
        return ret;
    }

    public static Block getEnclosingBlock(final Protocol protocol, final Role role) {
        Block ret = null;
        final Vector blocks = new Vector();
        protocol.visit(new DefaultVisitor(){

            public boolean start(Protocol elem) {
                if (protocol.getParameterDefinition(role.getName()) != null) {
                    blocks.add(elem.getBlock());
                }
                return protocol == elem;
            }

            public void accept(Interaction elem) {
                if (role.equals(elem.getFromRole()) || elem.getToRoles().contains(role) || (elem.getFromRole() == null || elem.getToRoles().size() == 0) && role.equals(elem.enclosingProtocol().getRole())) {
                    blocks.add((Block)elem.getParent());
                }
            }

            public boolean start(Choice elem) {
                if (role.equals(elem.getRole())) {
                    blocks.add((Block)elem.getParent());
                }
                return true;
            }

            public boolean start(DirectedChoice elem) {
                if (role.equals(elem.getFromRole()) || elem.getToRoles().contains(role)) {
                    blocks.add((Block)elem.getParent());
                }
                return true;
            }
        });
        if (blocks.size() != 0) {
            if (blocks.size() == 1) {
                ret = (Block)blocks.get(0);
            } else {
                Vector<List<Block>> listOfBlocks = new Vector<List<Block>>();
                for (Block block : blocks) {
                    List<Block> lb = RoleUtil.getBlockPath(block);
                    if (lb == null || lb.size() <= 0) continue;
                    listOfBlocks.add(lb);
                }
                int pos = -1;
                List refblocks = (List)listOfBlocks.get(0);
                for (int j = 0; j < refblocks.size(); ++j) {
                    boolean f_same = true;
                    Block ref = (Block)refblocks.get(j);
                    for (int i = 1; f_same && i < listOfBlocks.size(); ++i) {
                        List lb = (List)listOfBlocks.get(i);
                        if (lb.size() > j && ref == lb.get(j)) continue;
                        f_same = false;
                    }
                    if (!f_same) continue;
                    pos = j;
                }
                if (pos != -1) {
                    ret = (Block)refblocks.get(pos);
                }
            }
        }
        return ret;
    }

    protected static List<Block> getBlockPath(Block b) {
        Vector<Block> ret = new Vector<Block>();
        ModelObject cur = b;
        while (cur instanceof Block) {
            ret.add(0, (Block)cur);
            while ((cur = cur.getParent()) != null && !(cur instanceof Block)) {
            }
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoleLocator
    implements Visitor {
        private boolean m_recurse = true;
        private Protocol m_protocol = null;
        private Activity m_activity = null;
        private Set<Role> m_result = null;
        private List<List<Role>> m_roleStack = new Vector<List<Role>>();

        public RoleLocator(Protocol protocol, Activity activity, Set<Role> result) {
            this.m_protocol = protocol;
            this.m_activity = activity;
            this.m_result = result;
        }

        @Override
        public boolean start(Block elem) {
            return this.startBlock(elem);
        }

        protected boolean startBlock(Block elem) {
            this.m_roleStack.add(new Vector());
            return true;
        }

        @Override
        public void end(Block elem) {
            this.endBlock(elem);
        }

        protected void endBlock(Block elem) {
            this.m_roleStack.remove(this.m_roleStack.size() - 1);
        }

        @Override
        public void end(Choice elem) {
        }

        @Override
        public void end(DirectedChoice elem) {
        }

        @Override
        public void end(OnMessage elem) {
        }

        @Override
        public void end(Unordered elem) {
        }

        @Override
        public void end(Parallel elem) {
        }

        @Override
        public void end(Protocol elem) {
        }

        @Override
        public void end(Repeat elem) {
        }

        @Override
        public void end(RecBlock elem) {
        }

        @Override
        public void end(Do elem) {
        }

        @Override
        public void end(Interrupt elem) {
        }

        @Override
        public boolean start(Choice elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(DirectedChoice elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(OnMessage elem) {
            return this.m_recurse;
        }

        @Override
        public boolean start(Unordered elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(Parallel elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(Protocol elem) {
            boolean ret;
            boolean bl = ret = this.m_protocol == elem;
            if (ret) {
                Vector<Role> rlist = new Vector<Role>();
                this.m_roleStack.add(rlist);
                if (elem.getRole() != null) {
                    rlist.add(elem.getRole());
                }
                for (ParameterDefinition p : elem.getParameterDefinitions()) {
                    if (p.getType() != null) continue;
                    rlist.add(new Role(p.getName()));
                }
            }
            return ret;
        }

        @Override
        public boolean start(Repeat elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(RecBlock elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(Do elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(Interrupt elem) {
            return this.m_recurse;
        }

        @Override
        public void accept(Run elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(TypeImportList elem) {
        }

        @Override
        public void accept(ProtocolImportList elem) {
        }

        @Override
        public void accept(Interaction elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(Introduces elem) {
            List<Role> rlist = this.m_roleStack.get(this.m_roleStack.size() - 1);
            rlist.addAll(elem.getRoles());
        }

        @Override
        public void accept(Include elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(Recursion elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(TypeImport elem) {
        }

        @Override
        public void accept(ProtocolImport elem) {
        }

        @Override
        public void accept(End elem) {
            this.checkActivity(elem);
        }

        protected void checkActivity(Activity elem) {
            if (elem == this.m_activity) {
                for (List<Role> plist : this.m_roleStack) {
                    for (Role p : plist) {
                        this.m_result.add(p);
                    }
                }
                this.m_recurse = false;
            }
        }
    }
}

