/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.Collection;
import java.util.List;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interaction
extends Activity {
    private MessageSignature _messageSignature = null;
    private Role _fromRole = null;
    private List<Role> _toRoles = new ContainmentList<Role>(this, Role.class);

    public Interaction() {
    }

    public Interaction(Interaction i) {
        super(i);
        if (i._messageSignature != null) {
            this._messageSignature = new MessageSignature(i._messageSignature);
        }
        if (i._fromRole != null) {
            this._fromRole = new Role(i._fromRole);
        }
        for (Role r : i._toRoles) {
            this._toRoles.add(new Role(r));
        }
    }

    public Interaction(Role fromRole, MessageSignature sig) {
        this._fromRole = fromRole;
        this._messageSignature = sig;
    }

    public Interaction(Role fromRole, Role toRole, MessageSignature sig) {
        this(fromRole, sig);
        if (toRole != null) {
            this._toRoles.add(toRole);
        }
    }

    public Interaction(Role fromRole, Collection<Role> toRoles, MessageSignature sig) {
        this(fromRole, sig);
        this._toRoles.addAll(toRoles);
    }

    public MessageSignature getMessageSignature() {
        return this._messageSignature;
    }

    public void setMessageSignature(MessageSignature signature) {
        if (this._messageSignature != null) {
            this._messageSignature.setParent(null);
        }
        this._messageSignature = signature;
        if (this._messageSignature != null) {
            this._messageSignature.setParent(this);
        }
    }

    public Role getFromRole() {
        return this._fromRole;
    }

    public void setFromRole(Role part) {
        this._fromRole = part;
    }

    public List<Role> getToRoles() {
        return this._toRoles;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.getMessageSignature() != null) {
            ret.append(this.getMessageSignature());
            ret.append(" ");
        }
        if (this.getFromRole() != null) {
            ret.append(this.getFromRole());
            ret.append("->");
            for (int i = 0; i < this.getToRoles().size(); ++i) {
                if (i > 0) {
                    ret.append(",");
                }
                ret.append(this.getToRoles().get(i));
            }
        } else {
            ret.append("->");
            for (int i = 0; i < this.getToRoles().size(); ++i) {
                if (i > 0) {
                    ret.append(",");
                }
                ret.append(this.getToRoles().get(i));
            }
        }
        return ret.toString();
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.accept(this);
        if (this.getMessageSignature() != null) {
            this.getMessageSignature().visit(visitor);
        }
        if (this.getFromRole() != null) {
            this.getFromRole().visit(visitor);
        }
        for (Role r : this.getToRoles()) {
            r.visit(visitor);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interaction that = (Interaction)o;
        return !(this._fromRole == null ? that._fromRole != null : !this._fromRole.equals(that._fromRole)) && !(this._messageSignature == null ? that._messageSignature != null : !this._messageSignature.equals(that._messageSignature)) && ((Object)this._toRoles).equals(that._toRoles);
    }

    public int hashCode() {
        int result = this._messageSignature != null ? this._messageSignature.hashCode() : 0;
        result = 31 * result + (this._fromRole != null ? this._fromRole.hashCode() : 0);
        result = 31 * result + (this._toRoles != null ? ((Object)this._toRoles).hashCode() : 0);
        return result;
    }
}

