/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.scribble.protocol.model.Module;
import org.scribble.protocol.parser.ConsoleParserLogger;
import org.scribble.protocol.parser.DirectoryResourceLocator;
import org.scribble.protocol.parser.ParserLogger;
import org.scribble.protocol.parser.ProtocolParser;
import org.scribble.protocol.parser.ResourceLocator;

public class ScribbleCLI {
    private static final String SCRIBBLE_PATH = "SCRIBBLE_PATH";
    private ResourceLocator _locator = null;
    private Module _module = null;

    public static void main(String[] args) {
        ScribbleCLI cli = new ScribbleCLI();
        cli.execute(args);
    }

    public boolean execute(String[] args) {
        boolean f_error = false;
        if (args.length > 0) {
            for (int i = 0; !f_error && i < args.length - 1; ++i) {
                if (args[i].equals("-path")) {
                    if (i >= args.length - 2) {
                        System.err.println("ERROR: No path value has been defined\r\n");
                        f_error = true;
                        continue;
                    }
                    boolean bl = f_error = !ScribbleCLI.validatePaths(args[++i]);
                    if (!f_error) {
                        this._locator = new DirectoryResourceLocator(args[i]);
                        continue;
                    }
                    System.err.println("ERROR: Scribble path '" + args[i] + "' is not valid\r\n");
                    f_error = true;
                    continue;
                }
                if (args[i].equals("-project")) continue;
                System.err.println("ERROR: Unknown option '" + args[i] + "'\r\n");
                f_error = true;
            }
            if (!f_error && this._locator == null) {
                if (!System.getenv().containsKey(SCRIBBLE_PATH)) {
                    System.err.println("ERROR: SCRIBBLE_PATH has not been defined\r\n");
                    f_error = true;
                } else if (!ScribbleCLI.validatePaths(System.getenv().get(SCRIBBLE_PATH))) {
                    System.err.println("ERROR: Scribble path '" + System.getenv().get(SCRIBBLE_PATH) + "' is not valid\r\n");
                    f_error = true;
                } else {
                    this._locator = new DirectoryResourceLocator(System.getenv().get(SCRIBBLE_PATH));
                }
            }
            if (!f_error) {
                String module = args[args.length - 1];
                if (ScribbleCLI.validateModule(module)) {
                    ProtocolParser pp = new ProtocolParser();
                    InputStream is = this._locator.getModule(module);
                    if (is != null) {
                        try {
                            this._module = pp.parse(is, this._locator, (ParserLogger)new ConsoleParserLogger());
                            is.close();
                        }
                        catch (IOException e) {
                            System.err.println("ERROR: Failed to parse '" + module + "': " + e + "\r\n");
                        }
                    } else {
                        System.err.println("ERROR: Module name '" + module + "' could not be located\r\n");
                        f_error = true;
                    }
                } else {
                    System.err.println("ERROR: Module name '" + module + "' is not valid\r\n");
                    f_error = true;
                }
            }
        } else {
            f_error = true;
        }
        if (f_error) {
            System.err.println("Usage: scribble [-path <scribble-path>] [-project] module");
            System.err.println("Options:");
            System.err.println("\t-path\t\tlist of root directories separated by ':'");
            System.err.println("\t-project\tProject global protocols to local");
        }
        return !f_error;
    }

    protected static boolean validateModule(String module) {
        for (String part : module.split(".")) {
            for (int i = 0; i < part.length(); ++i) {
                if (Character.isLetterOrDigit(part.charAt(i)) || part.charAt(i) == '_') continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean validatePaths(String paths) {
        for (String path : paths.split(":")) {
            File f = new File(path);
            if (f.isDirectory()) continue;
            return false;
        }
        return true;
    }
}

