/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model.global;

import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.RoleInstantiation;
import org.scribble.protocol.model.global.GActivity;
import org.scribble.protocol.model.global.GVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSpawn
extends GActivity {
    private Role _role = null;
    private String _protocol = null;
    private List<MessageSignature> _arguments = new Vector<MessageSignature>();
    private List<RoleInstantiation> _roleInstantiations = new Vector<RoleInstantiation>();

    public GSpawn() {
    }

    public GSpawn(GSpawn copy) {
        super(copy);
        this._role = copy.getRole();
        this._protocol = copy.getProtocol();
        for (MessageSignature arg : copy.getArguments()) {
            this._arguments.add(new MessageSignature(arg));
        }
        for (RoleInstantiation ri : copy.getRoleInstantiations()) {
            this._roleInstantiations.add(new RoleInstantiation(ri));
        }
    }

    public Role getRole() {
        return this._role;
    }

    public void setRole(Role role) {
        this._role = role;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public List<MessageSignature> getArguments() {
        return this._arguments;
    }

    public List<RoleInstantiation> getRoleInstantiations() {
        return this._roleInstantiations;
    }

    @Override
    public void visit(GVisitor visitor) {
        visitor.accept(this);
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        int i;
        this.indent(buf, level);
        if (this._role != null) {
            this._role.toText(buf, level);
        }
        buf.append(" spawns ");
        buf.append(this._protocol);
        if (this._arguments.size() > 0) {
            buf.append('<');
            for (i = 0; i < this._arguments.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this._arguments.get(i));
            }
            buf.append(">");
        }
        buf.append("(");
        for (i = 0; i < this._roleInstantiations.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            this._roleInstantiations.get(i).toText(buf, level);
        }
        buf.append(");\n");
    }
}

