/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.parser.antlr;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.runtime.Token;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.parser.antlr.ParserContext;

public class DefaultParserContext
implements ParserContext {
    private static final Logger LOG = Logger.getLogger(DefaultParserContext.class.getName());
    private Stack<Object> _components = new Stack();
    private Map<String, Object> _properties = new HashMap<String, Object>();

    public Object pop() {
        Object child = this._components.peek();
        if (child instanceof Token) {
            Token token = (Token)child;
            this._properties.put("start.line", token.getLine());
            this._properties.put("start.column", token.getCharPositionInLine());
            if (!this._properties.containsKey("end.line")) {
                this._properties.put("end.line", token.getLine());
                this._properties.put("end.column", token.getCharPositionInLine() + token.getText().length());
            }
        } else if (child instanceof ModelObject) {
            ModelObject chobj = (ModelObject)child;
            this._properties.put("start.line", chobj.getProperties().get("start.line"));
            this._properties.put("start.column", chobj.getProperties().get("start.column"));
            if (!chobj.getProperties().containsKey("end.line")) {
                this._properties.put("end.line", chobj.getProperties().get("end.line"));
                this._properties.put("end.column", chobj.getProperties().get("end.column"));
            }
        }
        return this._components.pop();
    }

    public Object peek() {
        return this._components.peek();
    }

    public void push(Object obj) {
        this._components.push(obj);
        if (obj instanceof ModelObject) {
            ((ModelObject)obj).getProperties().putAll(this._properties);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Properties for '" + obj + "' are " + this._properties);
            }
        }
        this._properties.clear();
    }
}

