/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.common.module;

import java.util.HashMap;
import java.util.Map;
import org.scribble.common.module.ModuleCache;
import org.scribble.common.module.ModuleContext;
import org.scribble.common.module.ModuleLoader;
import org.scribble.common.resources.Resource;
import org.scribble.model.ModelObject;
import org.scribble.model.Module;
import org.scribble.model.ProtocolDecl;

public class DefaultModuleContext
implements ModuleContext {
    private Resource _resource = null;
    private Module _thisModule = null;
    private ModuleCache _modules = null;
    private Map<String, ModelObject> _importedMembers = new HashMap<String, ModelObject>();
    private ModuleLoader _loader = null;

    public DefaultModuleContext(Resource resource, Module thisModule, ModuleLoader loader, ModuleCache cache) {
        this._resource = resource;
        this._thisModule = thisModule;
        this._loader = loader;
        this._modules = cache == null ? new ModuleCache() : cache;
    }

    public Resource getResource() {
        return this._resource;
    }

    public void registerModule(Module module) {
        this._modules.register(module);
    }

    public Module importModule(String moduleName) {
        Module ret = this._modules.getModule(moduleName);
        if (ret == null && this._loader != null && (ret = this._loader.loadModule(moduleName)) != null) {
            this._modules.register(ret);
        }
        return ret;
    }

    public ModelObject getMember(String fqn) {
        int index = fqn.lastIndexOf(46);
        String moduleName = null;
        String memberName = null;
        if (index != -1) {
            moduleName = fqn.substring(0, index - 1);
            memberName = fqn.substring(index + 1);
        } else {
            memberName = fqn;
        }
        return this.getMember(moduleName, memberName);
    }

    public ModelObject getMember(String moduleName, String memberName) {
        Module module;
        ProtocolDecl ret = null;
        Module module2 = module = moduleName == null ? this._thisModule : this._modules.getModule(moduleName);
        if (module != null && (ret = module.getProtocol(memberName)) == null) {
            ret = module.getTypeDeclaration(memberName);
        }
        return ret;
    }

    public ModelObject getImportedMember(String name) {
        return this._importedMembers.get(name);
    }

    public ModelObject registerImportedMember(String module, String member, String alias) {
        ModelObject ret = this.getMember(module, member);
        if (ret != null) {
            if (alias != null) {
                this._importedMembers.put(alias, ret);
            } else {
                this._importedMembers.put(member, ret);
            }
        }
        return ret;
    }
}

