/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.common.resources;

import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scribble.common.resources.InputStreamResource;
import org.scribble.common.resources.Resource;
import org.scribble.common.resources.ResourceLocator;

public class DirectoryResourceLocator
implements ResourceLocator {
    private static final Logger LOG = Logger.getLogger(DirectoryResourceLocator.class.getName());
    private String[] _paths = null;

    public DirectoryResourceLocator(String paths) {
        this._paths = paths.split(":");
    }

    public Resource getResource(String name) {
        InputStreamResource ret = null;
        String relativePath = name.replace('.', File.separatorChar) + ".scr";
        for (String path : this._paths) {
            File f;
            String fullPath = path;
            if (!fullPath.endsWith(File.separator)) {
                fullPath = fullPath + File.separator;
            }
            if (!(f = new File(fullPath = fullPath + relativePath)).isFile()) continue;
            try {
                ret = new InputStreamResource(name, fullPath, new FileInputStream(f));
                break;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to create file input stream for '" + f + "'", e);
            }
        }
        return ret;
    }
}

