/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global;

import java.util.List;
import java.util.Set;
import org.scribble.model.ContainmentList;
import org.scribble.model.Message;
import org.scribble.model.ModelObject;
import org.scribble.model.Role;
import org.scribble.model.RoleDecl;
import org.scribble.model.Visitor;
import org.scribble.model.global.GBlock;
import org.scribble.model.global.GSinglePathActivity;
import org.scribble.model.global.GVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GInterruptible
extends GSinglePathActivity {
    private String _scope = null;
    private GBlock _block = new GBlock();
    private List<Interrupt> _interrupts = new ContainmentList<Interrupt>(this, Interrupt.class);

    public GInterruptible() {
        this._block.setParent(this);
    }

    @Override
    public boolean isRoleInvolved(RoleDecl role) {
        boolean ret = this._block.isRoleInvolved(role);
        for (int i = 0; !ret && i < this._interrupts.size(); ++i) {
            if (this._interrupts.get(i).getRole() == null) continue;
            ret = role.isRole(this._interrupts.get(i).getRole());
        }
        return ret;
    }

    @Override
    public void identifyInvolvedRoles(Set<Role> roles) {
        this._block.identifyInvolvedRoles(roles);
        for (int i = 0; i < this._interrupts.size(); ++i) {
            if (this._interrupts.get(i).getRole() == null) continue;
            roles.add(this._interrupts.get(i).getRole());
        }
    }

    public String getScope() {
        return this._scope;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    @Override
    public GBlock getBlock() {
        return this._block;
    }

    public void setBlock(GBlock block) {
        if (this._block != null) {
            this._block.setParent(null);
        }
        this._block = block;
        if (this._block != null) {
            this._block.setParent(this);
        }
    }

    public void setInterrupts(List<Interrupt> interrupts) {
        this._interrupts = interrupts;
    }

    public List<Interrupt> getInterrupts() {
        return this._interrupts;
    }

    @Override
    public void visit(GVisitor visitor) {
        if (visitor.start(this) && this.getBlock() != null) {
            this.getBlock().visit(visitor);
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GInterruptible that = (GInterruptible)o;
        return !(this._scope == null ? that._scope != null : !this._scope.equals(that._scope)) && !(this._block == null ? that._block != null : !this._block.equals(that._block));
    }

    public int hashCode() {
        int result = this._scope != null ? this._scope.hashCode() : 0;
        return 31 * result + (this._block != null ? this._block.hashCode() : 0);
    }

    public String toString() {
        return "interruptible " + this._scope + " " + this._block;
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        GInterruptible.indent(buf, level);
        buf.append("interruptible ");
        if (this._scope != null) {
            buf.append(this._scope);
            buf.append(": ");
        }
        if (this._block != null) {
            this._block.toText(buf, level);
        }
        buf.append(" with {\n");
        for (Interrupt i : this.getInterrupts()) {
            i.toText(buf, level + 1);
        }
        GInterruptible.indent(buf, level);
        buf.append("}\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Interrupt
    extends ModelObject {
        private Role _role = null;
        private List<Message> _messages = new ContainmentList<Message>(this, Message.class);

        public void setRole(Role role) {
            this._role = role;
        }

        public Role getRole() {
            return this._role;
        }

        public void setMessages(List<Message> mesgs) {
            this._messages = mesgs;
        }

        public List<Message> getMessages() {
            return this._messages;
        }

        @Override
        public void visit(Visitor visitor) {
        }

        @Override
        public void toText(StringBuffer buf, int level) {
            GInterruptible.indent(buf, level);
            for (int i = 0; i < this._messages.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                this._messages.get(i).toText(buf, level);
            }
            buf.append(" by ");
            this._role.toText(buf, level);
            buf.append(";\n");
        }
    }
}

