/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global;

import java.util.List;
import java.util.Set;
import org.scribble.model.ContainmentList;
import org.scribble.model.Role;
import org.scribble.model.RoleDecl;
import org.scribble.model.global.GBlock;
import org.scribble.model.global.GMultiPathActivity;
import org.scribble.model.global.GVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GParallel
extends GMultiPathActivity {
    private List<GBlock> _blocks = new ContainmentList<GBlock>(this, GBlock.class);

    @Override
    public boolean isRoleInvolved(RoleDecl role) {
        boolean ret = false;
        for (int i = 0; !ret && i < this._blocks.size(); ++i) {
            ret = this._blocks.get(i).isRoleInvolved(role);
        }
        return ret;
    }

    @Override
    public void identifyInvolvedRoles(Set<Role> roles) {
        for (GBlock b : this._blocks) {
            b.identifyInvolvedRoles(roles);
        }
    }

    @Override
    public List<GBlock> getPaths() {
        return this._blocks;
    }

    @Override
    public void visit(GVisitor visitor) {
        if (visitor.start(this)) {
            for (GBlock b : this.getPaths()) {
                b.visit(visitor);
            }
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GParallel that = (GParallel)o;
        return this._blocks.equals(that._blocks);
    }

    public int hashCode() {
        int result = this._blocks.hashCode();
        return result;
    }

    public String toString() {
        String result = "parallel ";
        for (GBlock b : this._blocks) {
            if (this._blocks.indexOf(b) > 0) {
                result = result + "and ";
            }
            result = result + b + "\n";
        }
        return result;
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        GParallel.indent(buf, level);
        buf.append("par ");
        for (int i = 0; i < this.getPaths().size(); ++i) {
            if (i > 0) {
                buf.append(" and ");
            }
            this.getPaths().get(i).toText(buf, level);
        }
        buf.append("\n");
    }
}

