/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global;

import java.util.List;
import org.scribble.model.Argument;
import org.scribble.model.ContainmentList;
import org.scribble.model.ParameterDecl;
import org.scribble.model.ProtocolDecl;
import org.scribble.model.RoleDecl;
import org.scribble.model.RoleInstantiation;
import org.scribble.model.Visitor;
import org.scribble.model.global.GVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GProtocolInstance
extends ProtocolDecl {
    private String _memberName = null;
    private List<Argument> _arguments = new ContainmentList<Argument>(this, Argument.class);
    private List<RoleInstantiation> _roleInstantiations = new ContainmentList<RoleInstantiation>(this, RoleInstantiation.class);

    public String getMemberName() {
        return this._memberName;
    }

    public void setMemberName(String name) {
        this._memberName = name;
    }

    public List<RoleInstantiation> getRoleInstantiations() {
        return this._roleInstantiations;
    }

    public List<Argument> getArguments() {
        return this._arguments;
    }

    @Override
    public void visit(Visitor visitor) {
        if (visitor instanceof GVisitor) {
            ((GVisitor)visitor).accept(this);
        }
    }

    public String toString() {
        int i;
        String ret = "global protocol " + this.getName();
        if (this.getParameterDeclarations().size() > 0) {
            ret = ret + " <";
            for (i = 0; i < this.getParameterDeclarations().size(); ++i) {
                ParameterDecl pd = this.getParameterDeclarations().get(i);
                if (i > 0) {
                    ret = ret + ",";
                }
                ret = ret + pd.getType().name().toLowerCase() + " " + pd.getName();
                if (pd.getAlias() == null) continue;
                ret = ret + " as " + pd.getAlias();
            }
            ret = ret + ">";
        }
        ret = ret + " ( ";
        for (i = 0; i < this.getRoleDeclarations().size(); ++i) {
            RoleDecl role = this.getRoleDeclarations().get(i);
            if (i > 0) {
                ret = ret + ",";
            }
            ret = ret + "role " + role.getName() + " ";
            if (role.getAlias() == null) continue;
            ret = ret + " as " + role.getAlias();
        }
        ret = ret + ") instantiates ";
        ret = ret + this._memberName;
        return ret;
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        int i;
        GProtocolInstance.indent(buf, level);
        buf.append("global protocol ");
        buf.append(this.getName());
        if (this.getParameterDeclarations().size() > 0) {
            buf.append("<");
            for (i = 0; i < this.getParameterDeclarations().size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                this.getParameterDeclarations().get(i).toText(buf, level);
            }
            buf.append(">");
        }
        buf.append("(");
        for (i = 0; i < this.getRoleDeclarations().size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append("role ");
            this.getRoleDeclarations().get(i).toText(buf, level);
        }
        buf.append(") instantiates ");
        buf.append(this.getMemberName());
        if (this.getArguments().size() > 0) {
            buf.append("<");
            for (i = 0; i < this.getArguments().size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                this.getArguments().get(i).toText(buf, level);
            }
            buf.append(">");
        }
        buf.append("(");
        for (i = 0; i < this.getRoleInstantiations().size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            this.getRoleInstantiations().get(i).toText(buf, level);
        }
        buf.append(");\n");
    }
}

