/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.monitor.export;

import org.scribble.common.module.ModuleContext;
import org.scribble.model.Message;
import org.scribble.model.ModelObject;
import org.scribble.model.PayloadElement;
import org.scribble.model.PayloadTypeDecl;
import org.scribble.model.Role;
import org.scribble.model.local.LBlock;
import org.scribble.model.local.LInterruptible;
import org.scribble.monitor.export.ExportState;
import org.scribble.monitor.export.NodeExporter;
import org.scribble.monitor.export.NodeExporterFactory;
import org.scribble.monitor.model.Choice;
import org.scribble.monitor.model.Interruptible;
import org.scribble.monitor.model.Receive;
import org.scribble.monitor.model.Send;
import org.scribble.monitor.model.SessionType;

public class LInterruptibleNodeExporter
implements NodeExporter {
    public void export(ModuleContext context, ExportState state, ModelObject mobj, SessionType type) {
        Choice choiceNode;
        LInterruptible elem = (LInterruptible)mobj;
        Interruptible interruptibleNode = new Interruptible();
        type.getNodes().add(interruptibleNode);
        interruptibleNode.setBlockIndex(type.getNodes().size());
        LBlock block = elem.getBlock();
        NodeExporter ne = NodeExporterFactory.getNodeExporter((ModelObject)block);
        ne.export(context, state, (ModelObject)block, type);
        if (elem.getThrows() != null && elem.getThrows().getMessages().size() > 0) {
            interruptibleNode.setThrows(type.getNodes().size());
            if (elem.getThrows().getMessages().size() > 1) {
                choiceNode = new Choice();
                type.getNodes().add(choiceNode);
                for (Message mesg : elem.getThrows().getMessages()) {
                    choiceNode.getPathIndexes().add(type.getNodes().size());
                    this.exportThrow(context, state, elem, type, mesg);
                }
            } else {
                this.exportThrow(context, state, elem, type, (Message)elem.getThrows().getMessages().get(0));
            }
        }
        if (elem.getCatches().size() > 0) {
            interruptibleNode.setCatches(type.getNodes().size());
            if (elem.getCatches().size() > 1 || ((LInterruptible.Catch)elem.getCatches().get(0)).getMessages().size() > 1) {
                choiceNode = new Choice();
                type.getNodes().add(choiceNode);
                for (LInterruptible.Catch c : elem.getCatches()) {
                    for (Message mesg : c.getMessages()) {
                        choiceNode.getPathIndexes().add(type.getNodes().size());
                        this.exportCatch(context, state, c, type, mesg);
                    }
                }
            } else {
                this.exportCatch(context, state, (LInterruptible.Catch)elem.getCatches().get(0), type, (Message)((LInterruptible.Catch)elem.getCatches().get(0)).getMessages().get(0));
            }
        }
    }

    protected void exportThrow(ModuleContext context, ExportState state, LInterruptible elem, SessionType type, Message mesg) {
        Send sendNode = new Send();
        sendNode.setOperator(mesg.getMessageSignature().getOperator());
        for (PayloadElement pe : mesg.getMessageSignature().getPayloadElements()) {
            ModelObject alias;
            PayloadTypeDecl ptype = elem.getModule().getTypeDeclaration(pe.getName());
            if (ptype == null && (alias = context.getImportedMember(pe.getName())) instanceof PayloadTypeDecl) {
                ptype = (PayloadTypeDecl)alias;
            }
            if (ptype == null) continue;
            sendNode.getTypes().add(ptype.getType());
        }
        sendNode.setToRole(((Role)elem.getThrows().getToRoles().get(0)).getName());
        type.getNodes().add(sendNode);
    }

    protected void exportCatch(ModuleContext context, ExportState state, LInterruptible.Catch elem, SessionType type, Message mesg) {
        Receive recvNode = new Receive();
        recvNode.setOperator(mesg.getMessageSignature().getOperator());
        for (PayloadElement pe : mesg.getMessageSignature().getPayloadElements()) {
            ModelObject alias;
            PayloadTypeDecl ptype = elem.getModule().getTypeDeclaration(pe.getName());
            if (ptype == null && (alias = context.getImportedMember(pe.getName())) instanceof PayloadTypeDecl) {
                ptype = (PayloadTypeDecl)alias;
            }
            if (ptype == null) continue;
            recvNode.getTypes().add(ptype.getType());
        }
        recvNode.setFromRole(elem.getRole().getName());
        type.getNodes().add(recvNode);
    }
}

