/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.monitor.export.rules;

import java.util.HashMap;
import java.util.Map;
import org.scribble.model.ModelObject;
import org.scribble.model.local.LBlock;
import org.scribble.model.local.LChoice;
import org.scribble.model.local.LContinue;
import org.scribble.model.local.LDo;
import org.scribble.model.local.LInterruptible;
import org.scribble.model.local.LParallel;
import org.scribble.model.local.LReceive;
import org.scribble.model.local.LRecursion;
import org.scribble.model.local.LSend;
import org.scribble.monitor.export.rules.LBlockNodeExporter;
import org.scribble.monitor.export.rules.LChoiceNodeExporter;
import org.scribble.monitor.export.rules.LContinueNodeExporter;
import org.scribble.monitor.export.rules.LDoNodeExporter;
import org.scribble.monitor.export.rules.LInterruptibleNodeExporter;
import org.scribble.monitor.export.rules.LParallelNodeExporter;
import org.scribble.monitor.export.rules.LReceiveNodeExporter;
import org.scribble.monitor.export.rules.LRecursionNodeExporter;
import org.scribble.monitor.export.rules.LSendNodeExporter;
import org.scribble.monitor.export.rules.NodeExporter;

public class NodeExporterFactory {
    private static Map<Class<? extends ModelObject>, NodeExporter> _nodeExporters = new HashMap<Class<? extends ModelObject>, NodeExporter>();

    public static NodeExporter getNodeExporter(ModelObject mobj) {
        return _nodeExporters.get(mobj.getClass());
    }

    static {
        _nodeExporters.put(LBlock.class, new LBlockNodeExporter());
        _nodeExporters.put(LChoice.class, new LChoiceNodeExporter());
        _nodeExporters.put(LContinue.class, new LContinueNodeExporter());
        _nodeExporters.put(LDo.class, new LDoNodeExporter());
        _nodeExporters.put(LInterruptible.class, new LInterruptibleNodeExporter());
        _nodeExporters.put(LParallel.class, new LParallelNodeExporter());
        _nodeExporters.put(LReceive.class, new LReceiveNodeExporter());
        _nodeExporters.put(LRecursion.class, new LRecursionNodeExporter());
        _nodeExporters.put(LSend.class, new LSendNodeExporter());
    }
}

