/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v104.tracing.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v104.io.model.StreamHandle;
import org.openqa.selenium.devtools.v104.tracing.model.StreamCompression;
import org.openqa.selenium.devtools.v104.tracing.model.StreamFormat;
import org.openqa.selenium.json.JsonInput;

public class TracingComplete {
    private final Boolean dataLossOccurred;
    private final Optional<StreamHandle> stream;
    private final Optional<StreamFormat> traceFormat;
    private final Optional<StreamCompression> streamCompression;

    public TracingComplete(Boolean dataLossOccurred, Optional<StreamHandle> stream, Optional<StreamFormat> traceFormat, Optional<StreamCompression> streamCompression) {
        this.dataLossOccurred = Objects.requireNonNull(dataLossOccurred, "dataLossOccurred is required");
        this.stream = stream;
        this.traceFormat = traceFormat;
        this.streamCompression = streamCompression;
    }

    public Boolean getDataLossOccurred() {
        return this.dataLossOccurred;
    }

    public Optional<StreamHandle> getStream() {
        return this.stream;
    }

    public Optional<StreamFormat> getTraceFormat() {
        return this.traceFormat;
    }

    public Optional<StreamCompression> getStreamCompression() {
        return this.streamCompression;
    }

    private static TracingComplete fromJson(JsonInput input) {
        Boolean dataLossOccurred = false;
        Optional<StreamHandle> stream = Optional.empty();
        Optional<StreamFormat> traceFormat = Optional.empty();
        Optional<StreamCompression> streamCompression = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "dataLossOccurred": {
                    dataLossOccurred = input.nextBoolean();
                    continue block12;
                }
                case "stream": {
                    stream = Optional.ofNullable((StreamHandle)input.read(StreamHandle.class));
                    continue block12;
                }
                case "traceFormat": {
                    traceFormat = Optional.ofNullable((StreamFormat)((Object)input.read(StreamFormat.class)));
                    continue block12;
                }
                case "streamCompression": {
                    streamCompression = Optional.ofNullable((StreamCompression)((Object)input.read(StreamCompression.class)));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TracingComplete(dataLossOccurred, stream, traceFormat, streamCompression);
    }
}

