package org.openqa.selenium.devtools.v137.bluetoothemulation;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain allows configuring virtual Bluetooth devices to test
 * the web-bluetooth API.
 */
@Beta()
public class BluetoothEmulation {

    /**
     * Enable the BluetoothEmulation domain.
     */
    public static Command<Void> enable(org.openqa.selenium.devtools.v137.bluetoothemulation.model.CentralState state, java.lang.Boolean leSupported) {
        java.util.Objects.requireNonNull(state, "state is required");
        java.util.Objects.requireNonNull(leSupported, "leSupported is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("state", state);
        params.put("leSupported", leSupported);
        return new Command<>("BluetoothEmulation.enable", Map.copyOf(params));
    }

    /**
     * Set the state of the simulated central.
     */
    public static Command<Void> setSimulatedCentralState(org.openqa.selenium.devtools.v137.bluetoothemulation.model.CentralState state) {
        java.util.Objects.requireNonNull(state, "state is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("state", state);
        return new Command<>("BluetoothEmulation.setSimulatedCentralState", Map.copyOf(params));
    }

    /**
     * Disable the BluetoothEmulation domain.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("BluetoothEmulation.disable", Map.copyOf(params));
    }

    /**
     * Simulates a peripheral with |address|, |name| and |knownServiceUuids|
     * that has already been connected to the system.
     */
    public static Command<Void> simulatePreconnectedPeripheral(java.lang.String address, java.lang.String name, java.util.List<org.openqa.selenium.devtools.v137.bluetoothemulation.model.ManufacturerData> manufacturerData, java.util.List<java.lang.String> knownServiceUuids) {
        java.util.Objects.requireNonNull(address, "address is required");
        java.util.Objects.requireNonNull(name, "name is required");
        java.util.Objects.requireNonNull(manufacturerData, "manufacturerData is required");
        java.util.Objects.requireNonNull(knownServiceUuids, "knownServiceUuids is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("address", address);
        params.put("name", name);
        params.put("manufacturerData", manufacturerData);
        params.put("knownServiceUuids", knownServiceUuids);
        return new Command<>("BluetoothEmulation.simulatePreconnectedPeripheral", Map.copyOf(params));
    }

    /**
     * Simulates an advertisement packet described in |entry| being received by
     * the central.
     */
    public static Command<Void> simulateAdvertisement(org.openqa.selenium.devtools.v137.bluetoothemulation.model.ScanEntry entry) {
        java.util.Objects.requireNonNull(entry, "entry is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("entry", entry);
        return new Command<>("BluetoothEmulation.simulateAdvertisement", Map.copyOf(params));
    }

    /**
     * Simulates the response code from the peripheral with |address| for a
     * GATT operation of |type|. The |code| value follows the HCI Error Codes from
     * Bluetooth Core Specification Vol 2 Part D 1.3 List Of Error Codes.
     */
    public static Command<Void> simulateGATTOperationResponse(java.lang.String address, org.openqa.selenium.devtools.v137.bluetoothemulation.model.GATTOperationType type, java.lang.Integer code) {
        java.util.Objects.requireNonNull(address, "address is required");
        java.util.Objects.requireNonNull(type, "type is required");
        java.util.Objects.requireNonNull(code, "code is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("address", address);
        params.put("type", type);
        params.put("code", code);
        return new Command<>("BluetoothEmulation.simulateGATTOperationResponse", Map.copyOf(params));
    }

    /**
     * Simulates the response from the characteristic with |characteristicId| for a
     * characteristic operation of |type|. The |code| value follows the Error
     * Codes from Bluetooth Core Specification Vol 3 Part F 3.4.1.1 Error Response.
     * The |data| is expected to exist when simulating a successful read operation
     * response.
     */
    public static Command<Void> simulateCharacteristicOperationResponse(java.lang.String characteristicId, org.openqa.selenium.devtools.v137.bluetoothemulation.model.CharacteristicOperationType type, java.lang.Integer code, java.util.Optional<java.lang.String> data) {
        java.util.Objects.requireNonNull(characteristicId, "characteristicId is required");
        java.util.Objects.requireNonNull(type, "type is required");
        java.util.Objects.requireNonNull(code, "code is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("characteristicId", characteristicId);
        params.put("type", type);
        params.put("code", code);
        data.ifPresent(p -> params.put("data", p));
        return new Command<>("BluetoothEmulation.simulateCharacteristicOperationResponse", Map.copyOf(params));
    }

    /**
     * Adds a service with |serviceUuid| to the peripheral with |address|.
     */
    public static Command<java.lang.String> addService(java.lang.String address, java.lang.String serviceUuid) {
        java.util.Objects.requireNonNull(address, "address is required");
        java.util.Objects.requireNonNull(serviceUuid, "serviceUuid is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("address", address);
        params.put("serviceUuid", serviceUuid);
        return new Command<>("BluetoothEmulation.addService", Map.copyOf(params), ConverterFunctions.map("serviceId", java.lang.String.class));
    }

    /**
     * Removes the service respresented by |serviceId| from the simulated central.
     */
    public static Command<Void> removeService(java.lang.String serviceId) {
        java.util.Objects.requireNonNull(serviceId, "serviceId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("serviceId", serviceId);
        return new Command<>("BluetoothEmulation.removeService", Map.copyOf(params));
    }

    /**
     * Adds a characteristic with |characteristicUuid| and |properties| to the
     * service represented by |serviceId|.
     */
    public static Command<java.lang.String> addCharacteristic(java.lang.String serviceId, java.lang.String characteristicUuid, org.openqa.selenium.devtools.v137.bluetoothemulation.model.CharacteristicProperties properties) {
        java.util.Objects.requireNonNull(serviceId, "serviceId is required");
        java.util.Objects.requireNonNull(characteristicUuid, "characteristicUuid is required");
        java.util.Objects.requireNonNull(properties, "properties is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("serviceId", serviceId);
        params.put("characteristicUuid", characteristicUuid);
        params.put("properties", properties);
        return new Command<>("BluetoothEmulation.addCharacteristic", Map.copyOf(params), ConverterFunctions.map("characteristicId", java.lang.String.class));
    }

    /**
     * Removes the characteristic respresented by |characteristicId| from the
     * simulated central.
     */
    public static Command<Void> removeCharacteristic(java.lang.String characteristicId) {
        java.util.Objects.requireNonNull(characteristicId, "characteristicId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("characteristicId", characteristicId);
        return new Command<>("BluetoothEmulation.removeCharacteristic", Map.copyOf(params));
    }

    /**
     * Adds a descriptor with |descriptorUuid| to the characteristic respresented
     * by |characteristicId|.
     */
    public static Command<java.lang.String> addDescriptor(java.lang.String characteristicId, java.lang.String descriptorUuid) {
        java.util.Objects.requireNonNull(characteristicId, "characteristicId is required");
        java.util.Objects.requireNonNull(descriptorUuid, "descriptorUuid is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("characteristicId", characteristicId);
        params.put("descriptorUuid", descriptorUuid);
        return new Command<>("BluetoothEmulation.addDescriptor", Map.copyOf(params), ConverterFunctions.map("descriptorId", java.lang.String.class));
    }

    /**
     * Removes the descriptor with |descriptorId| from the simulated central.
     */
    public static Command<Void> removeDescriptor(java.lang.String descriptorId) {
        java.util.Objects.requireNonNull(descriptorId, "descriptorId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("descriptorId", descriptorId);
        return new Command<>("BluetoothEmulation.removeDescriptor", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v137.bluetoothemulation.model.GattOperationReceived> gattOperationReceived() {
        return new Event<>("BluetoothEmulation.gattOperationReceived", input -> input.read(org.openqa.selenium.devtools.v137.bluetoothemulation.model.GattOperationReceived.class));
    }

    public static Event<org.openqa.selenium.devtools.v137.bluetoothemulation.model.CharacteristicOperationReceived> characteristicOperationReceived() {
        return new Event<>("BluetoothEmulation.characteristicOperationReceived", input -> input.read(org.openqa.selenium.devtools.v137.bluetoothemulation.model.CharacteristicOperationReceived.class));
    }
}
