package org.openqa.selenium.devtools.v137.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS font-palette-values rule representation.
 */
public class CSSFontPaletteValuesRule {

    private final java.util.Optional<org.openqa.selenium.devtools.v137.css.model.StyleSheetId> styleSheetId;

    private final org.openqa.selenium.devtools.v137.css.model.StyleSheetOrigin origin;

    private final org.openqa.selenium.devtools.v137.css.model.Value fontPaletteName;

    private final org.openqa.selenium.devtools.v137.css.model.CSSStyle style;

    public CSSFontPaletteValuesRule(java.util.Optional<org.openqa.selenium.devtools.v137.css.model.StyleSheetId> styleSheetId, org.openqa.selenium.devtools.v137.css.model.StyleSheetOrigin origin, org.openqa.selenium.devtools.v137.css.model.Value fontPaletteName, org.openqa.selenium.devtools.v137.css.model.CSSStyle style) {
        this.styleSheetId = styleSheetId;
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.fontPaletteName = java.util.Objects.requireNonNull(fontPaletteName, "fontPaletteName is required");
        this.style = java.util.Objects.requireNonNull(style, "style is required");
    }

    /**
     * The css style sheet identifier (absent for user agent stylesheet and user-specified
     * stylesheet rules) this rule came from.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v137.css.model.StyleSheetId> getStyleSheetId() {
        return styleSheetId;
    }

    /**
     * Parent stylesheet's origin.
     */
    public org.openqa.selenium.devtools.v137.css.model.StyleSheetOrigin getOrigin() {
        return origin;
    }

    /**
     * Associated font palette name.
     */
    public org.openqa.selenium.devtools.v137.css.model.Value getFontPaletteName() {
        return fontPaletteName;
    }

    /**
     * Associated style declaration.
     */
    public org.openqa.selenium.devtools.v137.css.model.CSSStyle getStyle() {
        return style;
    }

    private static CSSFontPaletteValuesRule fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v137.css.model.StyleSheetId> styleSheetId = java.util.Optional.empty();
        org.openqa.selenium.devtools.v137.css.model.StyleSheetOrigin origin = null;
        org.openqa.selenium.devtools.v137.css.model.Value fontPaletteName = null;
        org.openqa.selenium.devtools.v137.css.model.CSSStyle style = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "styleSheetId":
                    styleSheetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v137.css.model.StyleSheetId.class));
                    break;
                case "origin":
                    origin = input.read(org.openqa.selenium.devtools.v137.css.model.StyleSheetOrigin.class);
                    break;
                case "fontPaletteName":
                    fontPaletteName = input.read(org.openqa.selenium.devtools.v137.css.model.Value.class);
                    break;
                case "style":
                    style = input.read(org.openqa.selenium.devtools.v137.css.model.CSSStyle.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSFontPaletteValuesRule(styleSheetId, origin, fontPaletteName, style);
    }
}
