package org.openqa.selenium.devtools.v137.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A cache has been added/deleted.
 */
public class CacheStorageListUpdated {

    private final java.lang.String origin;

    private final java.lang.String storageKey;

    private final java.lang.String bucketId;

    public CacheStorageListUpdated(java.lang.String origin, java.lang.String storageKey, java.lang.String bucketId) {
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.storageKey = java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        this.bucketId = java.util.Objects.requireNonNull(bucketId, "bucketId is required");
    }

    /**
     * Origin to update.
     */
    public java.lang.String getOrigin() {
        return origin;
    }

    /**
     * Storage key to update.
     */
    public java.lang.String getStorageKey() {
        return storageKey;
    }

    /**
     * Storage bucket to update.
     */
    public java.lang.String getBucketId() {
        return bucketId;
    }

    private static CacheStorageListUpdated fromJson(JsonInput input) {
        java.lang.String origin = null;
        java.lang.String storageKey = null;
        java.lang.String bucketId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "origin":
                    origin = input.nextString();
                    break;
                case "storageKey":
                    storageKey = input.nextString();
                    break;
                case "bucketId":
                    bucketId = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CacheStorageListUpdated(origin, storageKey, bucketId);
    }
}
