package org.openqa.selenium.devtools.v137.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Details for an origin's shared storage.
 */
public class SharedStorageMetadata {

    private final org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch creationTime;

    private final java.lang.Integer length;

    private final java.lang.Number remainingBudget;

    private final java.lang.Integer bytesUsed;

    public SharedStorageMetadata(org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch creationTime, java.lang.Integer length, java.lang.Number remainingBudget, java.lang.Integer bytesUsed) {
        this.creationTime = java.util.Objects.requireNonNull(creationTime, "creationTime is required");
        this.length = java.util.Objects.requireNonNull(length, "length is required");
        this.remainingBudget = java.util.Objects.requireNonNull(remainingBudget, "remainingBudget is required");
        this.bytesUsed = java.util.Objects.requireNonNull(bytesUsed, "bytesUsed is required");
    }

    /**
     * Time when the origin's shared storage was last created.
     */
    public org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch getCreationTime() {
        return creationTime;
    }

    /**
     * Number of key-value pairs stored in origin's shared storage.
     */
    public java.lang.Integer getLength() {
        return length;
    }

    /**
     * Current amount of bits of entropy remaining in the navigation budget.
     */
    public java.lang.Number getRemainingBudget() {
        return remainingBudget;
    }

    /**
     * Total number of bytes stored as key-value pairs in origin's shared
     * storage.
     */
    public java.lang.Integer getBytesUsed() {
        return bytesUsed;
    }

    private static SharedStorageMetadata fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch creationTime = null;
        java.lang.Integer length = 0;
        java.lang.Number remainingBudget = 0;
        java.lang.Integer bytesUsed = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "creationTime":
                    creationTime = input.read(org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch.class);
                    break;
                case "length":
                    length = input.nextNumber().intValue();
                    break;
                case "remainingBudget":
                    remainingBudget = input.nextNumber();
                    break;
                case "bytesUsed":
                    bytesUsed = input.nextNumber().intValue();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedStorageMetadata(creationTime, length, remainingBudget, bytesUsed);
    }
}
