package org.openqa.selenium.devtools.v85.applicationcache;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class ApplicationCache {

    /**
     * Enables application cache domain notifications.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("ApplicationCache.enable", Map.copyOf(params));
    }

    /**
     * Returns relevant application cache data for the document in given frame.
     */
    public static Command<org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCache> getApplicationCacheForFrame(org.openqa.selenium.devtools.v85.page.model.FrameId frameId) {
        java.util.Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("frameId", frameId);
        return new Command<>("ApplicationCache.getApplicationCacheForFrame", Map.copyOf(params), ConverterFunctions.map("applicationCache", org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCache.class));
    }

    /**
     * Returns array of frame identifiers with manifest urls for each frame containing a document
     * associated with some application cache.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v85.applicationcache.model.FrameWithManifest>> getFramesWithManifests() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("ApplicationCache.getFramesWithManifests", Map.copyOf(params), ConverterFunctions.map("frameIds", input -> input.readArray(org.openqa.selenium.devtools.v85.applicationcache.model.FrameWithManifest.class)));
    }

    /**
     * Returns manifest URL for document in the given frame.
     */
    public static Command<java.lang.String> getManifestForFrame(org.openqa.selenium.devtools.v85.page.model.FrameId frameId) {
        java.util.Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("frameId", frameId);
        return new Command<>("ApplicationCache.getManifestForFrame", Map.copyOf(params), ConverterFunctions.map("manifestURL", java.lang.String.class));
    }

    public static Event<org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCacheStatusUpdated> applicationCacheStatusUpdated() {
        return new Event<>("ApplicationCache.applicationCacheStatusUpdated", input -> input.read(org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCacheStatusUpdated.class));
    }

    public static Event<java.lang.Boolean> networkStateUpdated() {
        return new Event<>("ApplicationCache.networkStateUpdated", ConverterFunctions.map("isNowOnline", java.lang.Boolean.class));
    }
}
