/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.FileBackedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.AcceptedW3CCapabilityKeys;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.Dialect;

public class NewSessionPayload
implements Closeable {
    private static final Dialect DEFAULT_DIALECT = Dialect.W3C;
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = new AcceptedW3CCapabilityKeys();
    private final Json json = new Json();
    private final FileBackedOutputStream backingStore;
    private final ImmutableSet<Dialect> dialects;

    private NewSessionPayload(Reader source) {
        int threshold = (int)Math.min(Integer.MAX_VALUE, Math.min(Runtime.getRuntime().freeMemory() / 5L, Runtime.getRuntime().maxMemory() / 10L));
        this.backingStore = new FileBackedOutputStream(threshold);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.backingStore, StandardCharsets.UTF_8);){
            CharStreams.copy((Readable)source, (Appendable)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ImmutableSet.Builder dialects = ImmutableSet.builder();
        try {
            if (this.isW3C()) {
                dialects.add((Object)Dialect.W3C);
            }
            this.dialects = dialects.build();
            this.validate();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            source.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static NewSessionPayload create(Capabilities caps) {
        Require.nonNull((String)"Capabilities", (Object)caps);
        return NewSessionPayload.create(Collections.singleton(caps));
    }

    public static NewSessionPayload create(Collection<Capabilities> caps) {
        return NewSessionPayload.create(ImmutableMap.of((Object)"capabilities", (Object)ImmutableMap.of((Object)"firstMatch", caps.stream().map(Capabilities::asMap).collect(Collectors.toList()))));
    }

    public static NewSessionPayload create(Map<String, ?> source) {
        Require.precondition((boolean)source.containsKey("capabilities"), (String)"New session payload must contain capabilities", (Object[])new Object[0]);
        String json = new Json().toJson(Require.nonNull((String)"Payload", source));
        return new NewSessionPayload(new StringReader(json));
    }

    public static NewSessionPayload create(Reader source) {
        return new NewSessionPayload(source);
    }

    private void validate() throws IOException {
        ImmutableMap alwaysMatch = this.getAlwaysMatch();
        if (alwaysMatch == null) {
            alwaysMatch = ImmutableMap.of();
        }
        ImmutableMap always = alwaysMatch;
        ImmutableList firsts = this.getFirstMatches();
        if (firsts == null) {
            firsts = ImmutableList.of((Object)ImmutableMap.of());
        }
        if (firsts.isEmpty()) {
            throw new IllegalArgumentException("First match w3c capabilities is zero length");
        }
        firsts.stream().peek(arg_0 -> NewSessionPayload.lambda$validate$0((Map)always, arg_0)).map(arg_0 -> NewSessionPayload.lambda$validate$1((Map)always, arg_0)).peek(map -> {
            ImmutableSortedSet nullKeys = (ImmutableSortedSet)map.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)Ordering.natural()));
            if (!nullKeys.isEmpty()) {
                throw new IllegalArgumentException("Null values found in w3c capabilities. Keys are: " + nullKeys);
            }
        }).peek(map -> {
            ImmutableSortedSet illegalKeys = (ImmutableSortedSet)map.keySet().stream().filter(ACCEPTED_W3C_PATTERNS.negate()).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)Ordering.natural()));
            if (!illegalKeys.isEmpty()) {
                throw new IllegalArgumentException("Illegal key values seen in w3c capabilities: " + illegalKeys);
            }
        }).forEach(map -> {});
    }

    public void writeTo(Appendable appendable) throws IOException {
        try (JsonOutput json = new Json().newOutput(appendable);){
            json.beginObject();
            json.name("capabilities");
            json.beginObject();
            json.name("firstMatch");
            json.beginArray();
            this.getW3C().forEach(arg_0 -> ((JsonOutput)json).write(arg_0));
            json.endArray();
            json.endObject();
            this.writeMetaData(json);
            json.endObject();
        }
    }

    private void writeMetaData(JsonOutput out) throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput((Reader)reader);){
            input.beginObject();
            block18: while (input.hasNext()) {
                String name;
                switch (name = input.nextName()) {
                    case "capabilities": 
                    case "desiredCapabilities": 
                    case "requiredCapabilities": {
                        input.skipValue();
                        continue block18;
                    }
                }
                out.name(name);
                out.write(input.read(Object.class));
            }
        }
    }

    public Stream<Capabilities> stream() {
        try {
            return this.getW3C().filter(Objects::nonNull).distinct().map(ImmutableCapabilities::new);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Set<Dialect> getDownstreamDialects() {
        return this.dialects.isEmpty() ? ImmutableSet.of((Object)((Object)DEFAULT_DIALECT)) : this.dialects;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getMetadata() {
        ImmutableSet ignoredMetadataKeys = ImmutableSet.of((Object)"capabilities", (Object)"desiredCapabilities", (Object)"requiredCapabilities");
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();){
            ImmutableMap immutableMap;
            block16: {
                JsonInput input = this.json.newInput((Reader)reader);
                try {
                    ImmutableMap.Builder toReturn = ImmutableMap.builder();
                    input.beginObject();
                    while (input.hasNext()) {
                        String name = input.nextName();
                        if (ignoredMetadataKeys.contains(name)) {
                            input.skipValue();
                            continue;
                        }
                        Object value = input.read(Object.class);
                        if (value == null) continue;
                        toReturn.put((Object)name, value);
                    }
                    input.endObject();
                    immutableMap = toReturn.build();
                    if (input == null) break block16;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return immutableMap;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.backingStore.reset();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Stream<Map<String, Object>> getW3C() throws IOException {
        Stream<Map> fromW3c;
        ImmutableMap alwaysMatch = this.getAlwaysMatch();
        ImmutableList firsts = this.getFirstMatches();
        if (alwaysMatch == null && firsts == null) {
            fromW3c = Stream.of(new Map[0]);
        } else {
            if (alwaysMatch == null) {
                alwaysMatch = ImmutableMap.of();
            }
            ImmutableMap always = alwaysMatch;
            if (firsts == null) {
                firsts = ImmutableList.of((Object)ImmutableMap.of());
            }
            fromW3c = firsts.stream().map(arg_0 -> NewSessionPayload.lambda$getW3C$6((Map)always, arg_0));
        }
        return fromW3c.distinct();
    }

    private boolean isW3C() throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput((Reader)reader);){
            input.beginObject();
            while (true) {
                if (input.hasNext()) {
                    String name = input.nextName();
                    if ("capabilities".equals(name)) {
                        boolean bl = true;
                        return bl;
                    }
                    input.skipValue();
                    continue;
                }
                break;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, Object> getAlwaysMatch() throws IOException {
        block17: {
            charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
            reader = charSource.openBufferedStream();
            try {
                input = this.json.newInput((Reader)reader);
                try {
                    input.beginObject();
                    while (true) {
                        block19: {
                            block20: {
                                block18: {
                                    if (!input.hasNext()) break block17;
                                    name = input.nextName();
                                    if (!"capabilities".equals(name)) break block19;
                                    input.beginObject();
lbl12:
                                    // 2 sources

                                    while (input.hasNext()) {
                                        name = input.nextName();
                                        if ("alwaysMatch".equals(name)) {
                                            var5_8 = (Map)input.read(Json.MAP_TYPE);
                                            return var5_8;
                                        }
                                        break block18;
                                    }
                                    break block20;
                                }
                                input.skipValue();
                                ** GOTO lbl12
                            }
                            input.endObject();
                            continue;
                        }
                        input.skipValue();
                    }
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return ImmutableMap.of();
    }

    /*
     * Unable to fully structure code
     */
    private Collection<Map<String, Object>> getFirstMatches() throws IOException {
        block17: {
            charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
            reader = charSource.openBufferedStream();
            try {
                input = this.json.newInput((Reader)reader);
                try {
                    input.beginObject();
                    while (true) {
                        block19: {
                            block20: {
                                block18: {
                                    if (!input.hasNext()) break block17;
                                    name = input.nextName();
                                    if (!"capabilities".equals(name)) break block19;
                                    input.beginObject();
lbl12:
                                    // 2 sources

                                    while (input.hasNext()) {
                                        name = input.nextName();
                                        if ("firstMatch".equals(name)) {
                                            var5_8 = (Collection)input.read(Json.LIST_OF_MAPS_TYPE);
                                            return var5_8;
                                        }
                                        break block18;
                                    }
                                    break block20;
                                }
                                input.skipValue();
                                ** GOTO lbl12
                            }
                            input.endObject();
                            continue;
                        }
                        input.skipValue();
                    }
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return ImmutableList.of((Object)ImmutableMap.of());
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        try {
            this.writeTo(res);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res.toString();
    }

    private static /* synthetic */ Map lambda$getW3C$6(Map always, Map first) {
        return ImmutableMap.builder().putAll(always).putAll(first).build();
    }

    private static /* synthetic */ Map lambda$validate$1(Map always, Map first) {
        HashMap toReturn = new HashMap();
        toReturn.putAll(always);
        toReturn.putAll(first);
        return toReturn;
    }

    private static /* synthetic */ void lambda$validate$0(Map always, Map map) {
        Sets.SetView overlap = Sets.intersection(always.keySet(), map.keySet());
        if (!overlap.isEmpty()) {
            throw new IllegalArgumentException("Overlapping keys between w3c always and first match capabilities: " + (Set)overlap);
        }
    }
}

