/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.filesystem;

import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.datasource.config.DomainBoundableDataSource;
import org.semanticdesktop.aperture.datasource.filesystem.FILESYSTEMDS;

public class FileSystemDataSource
extends DomainBoundableDataSource {
    public URI getType() {
        return FILESYSTEMDS.FileSystemDataSource;
    }

    public String getRootFolder() {
        return this.getConfiguration().getString(FILESYSTEMDS.rootFolder);
    }

    public void setRootFolder(String string) {
        if (string == null) {
            this.getConfiguration().remove(FILESYSTEMDS.rootFolder);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.rootFolder, string);
        }
    }

    public Integer getMaximumDepth() {
        return this.getConfiguration().getInteger(FILESYSTEMDS.maximumDepth);
    }

    public void setMaximumDepth(Integer n) {
        if (n == null) {
            this.getConfiguration().remove(FILESYSTEMDS.maximumDepth);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.maximumDepth, n);
        }
    }

    public Long getMaximumSize() {
        return this.getConfiguration().getLong(FILESYSTEMDS.maximumSize);
    }

    public void setMaximumSize(Long l) {
        if (l == null) {
            this.getConfiguration().remove(FILESYSTEMDS.maximumSize);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.maximumSize, l);
        }
    }

    public Boolean getIncludeHiddenResources() {
        return this.getConfiguration().getBoolean(FILESYSTEMDS.includeHiddenResources);
    }

    public void setIncludeHiddenResources(Boolean bl) {
        if (bl == null) {
            this.getConfiguration().remove(FILESYSTEMDS.includeHiddenResources);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.includeHiddenResources, bl);
        }
    }

    public Boolean getFollowSymbolicLinks() {
        return this.getConfiguration().getBoolean(FILESYSTEMDS.followSymbolicLinks);
    }

    public void setFollowSymbolicLinks(Boolean bl) {
        if (bl == null) {
            this.getConfiguration().remove(FILESYSTEMDS.followSymbolicLinks);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.followSymbolicLinks, bl);
        }
    }

    public Boolean getSuppressParentChildLinks() {
        return this.getConfiguration().getBoolean(FILESYSTEMDS.suppressParentChildLinks);
    }

    public void setSuppressParentChildLinks(Boolean bl) {
        if (bl == null) {
            this.getConfiguration().remove(FILESYSTEMDS.suppressParentChildLinks);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.suppressParentChildLinks, bl);
        }
    }
}

