/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.outlook;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComFailException;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.config.ConfigurationUtil;
import org.semanticdesktop.aperture.datasource.config.DomainBoundaries;
import org.semanticdesktop.aperture.opener.DataOpener;
import org.semanticdesktop.aperture.outlook.OutlookAccessor;
import org.semanticdesktop.aperture.outlook.OutlookDataSource;
import org.semanticdesktop.aperture.outlook.OutlookResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookCrawler
extends CrawlerBase
implements DataOpener {
    private static int crashed = 0;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String NS = "http://www.gnowsis.org/ont/msoutlook/0.1#";
    private OutlookAccessor accessor;
    private DomainBoundaries boundaries;
    protected String calendarTimeZone = "http://www.w3.org/2002/12/cal/tzd/Europe/Vienna#tz";
    private boolean hasRedemption = false;
    Dispatch outlookApp;
    Dispatch outlookMapi;
    private HashMap params;
    private String uriPrefix;

    protected void beginCall() {
        if (this.source == null) {
            throw new RuntimeException("cannot prepare crawler, datasource not set");
        }
        try {
            ComThread.doCoInitialize((int)0);
        }
        catch (Throwable throwable) {
            this.logger.error("Cannot init Com", throwable);
        }
        try {
            ActiveXComponent activeXComponent = new ActiveXComponent("Redemption.SafeContactItem");
            activeXComponent.safeRelease();
            this.hasRedemption = true;
            this.logger.info("found Oulook-Redemption and will use it to access information.");
        }
        catch (ComFailException comFailException) {
            this.logger.warn("You will be bugged by MS-Outlook messages. To avoid that, download and install redemption from http://www.dimastr.com/redemption/");
            this.hasRedemption = false;
        }
        this.outlookApp = new ActiveXComponent("Outlook.Application");
        this.outlookMapi = Dispatch.call((Dispatch)this.outlookApp, (String)"GetNamespace", (Object)"MAPI").toDispatch();
        this.accessor = new OutlookAccessor();
    }

    public void crashChecker(Throwable throwable) {
        if (++crashed > 2) {
            crashed = 0;
        } else {
            this.logger.warn("Outlook crashed. This is the " + crashed + " time. Will restart ActiveX on 3rd fail. ", throwable);
        }
    }

    private boolean crawlContainer(OutlookResource.Folder folder, OutlookResource outlookResource) {
        this.logger.info("crawling folder: " + folder.getUri());
        this.crawlSingleResource(folder, outlookResource);
        boolean bl = this.crawlSubItems(folder);
        if (!bl) {
            return false;
        }
        bl = this.crawlSubFolders(folder);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExitCode crawlObjects() {
        this.beginCall();
        try {
            ExitCode exitCode;
            OutlookResource.RootFolder rootFolder = new OutlookResource.RootFolder(this);
            try {
                this.params = new HashMap(2);
                boolean bl = this.crawlRoot(rootFolder);
                this.params = null;
                exitCode = bl ? ExitCode.COMPLETED : ExitCode.STOP_REQUESTED;
            }
            catch (Throwable throwable) {
                rootFolder.release();
                throw throwable;
            }
            rootFolder.release();
            return exitCode;
        }
        finally {
            this.endCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean crawlRoot(OutlookResource.RootFolder rootFolder) {
        this.crawlSingleResource(rootFolder, null);
        Variant variant = Dispatch.get((Dispatch)rootFolder.getResource(), (String)"Folders");
        if (variant == null) {
            return true;
        }
        Dispatch dispatch = variant.toDispatch();
        try {
            int n;
            int n2 = Dispatch.get((Dispatch)dispatch, (String)"Count").toInt();
            if (n2 == 0) {
                boolean bl = true;
                return bl;
            }
            for (n = 1; !this.stopRequested && n <= n2; ++n) {
                try {
                    Dispatch dispatch2 = Dispatch.invoke((Dispatch)dispatch, (String)"Item", (int)2, (Object[])new Object[]{new Integer(n)}, (int[])new int[1]).toDispatch();
                    OutlookResource.Folder folder = OutlookResource.createWrapperForFolder(this, dispatch2);
                    try {
                        if (this.boundaries.inDomain(folder.getUri())) {
                            this.crawlContainer(folder, rootFolder);
                            continue;
                        }
                        this.logger.info("not in domain, stepping over: " + folder.getUri());
                        continue;
                    }
                    finally {
                        folder.release();
                    }
                }
                catch (Exception exception) {
                    this.logger.warn("Error while adding subfolders of " + rootFolder.getUri(), (Throwable)exception);
                }
            }
            if (n <= n2) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            dispatch.safeRelease();
        }
        return true;
    }

    private void crawlSingleResource(OutlookResource outlookResource, OutlookResource outlookResource2) {
        String string = outlookResource.getUri();
        this.logger.info("crawling resource " + string);
        this.reportAccessingObject(string);
        boolean bl = this.accessData == null ? false : this.accessData.isKnownId(string);
        RDFContainerFactory rDFContainerFactory = this.getRDFContainerFactory(string);
        try {
            DataObject dataObject = this.getAccessor().getDataObjectIfModifiedOutlook(string, this.source, this.accessData, this.params, rDFContainerFactory, outlookResource, outlookResource2);
            if (dataObject == null) {
                this.reportUnmodifiedDataObject(string);
            } else if (bl) {
                this.reportModifiedDataObject(dataObject);
            } else {
                this.reportNewDataObject(dataObject);
            }
        }
        catch (UrlNotFoundException urlNotFoundException) {
            this.logger.warn("unable to access " + string, (Throwable)urlNotFoundException);
        }
        catch (IOException iOException) {
            this.logger.warn("I/O error while processing " + string, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean crawlSubFolders(OutlookResource.Folder folder) {
        Variant variant = Dispatch.get((Dispatch)folder.getResource(), (String)"Folders");
        if (variant == null) {
            return true;
        }
        Dispatch dispatch = variant.toDispatch();
        ArrayList<OutlookResource.Folder> arrayList = new ArrayList<OutlookResource.Folder>();
        try {
            Dispatch dispatch2;
            int n;
            int n2 = Dispatch.get((Dispatch)dispatch, (String)"Count").toInt();
            if (n2 == 0) {
                boolean bl = true;
                return bl;
            }
            for (n = 1; !this.stopRequested && n <= n2; ++n) {
                try {
                    dispatch2 = Dispatch.invoke((Dispatch)dispatch, (String)"Item", (int)2, (Object[])new Object[]{new Integer(n)}, (int[])new int[1]).toDispatch();
                    OutlookResource.Folder object = OutlookResource.createWrapperForFolder(this, dispatch2);
                    int n3 = object.getDefaultItemType();
                    boolean bl = false;
                    if (n3 == 0) {
                        bl = true;
                        String string = object.getName();
                        if (string != null && ((string = string.toLowerCase()).contains("kontakte") || string.contains("Contacts"))) {
                            bl = false;
                        }
                    }
                    if (bl) {
                        arrayList.add(object);
                        continue;
                    }
                    try {
                        this.crawlContainer(object, folder);
                        continue;
                    }
                    finally {
                        object.release();
                    }
                }
                catch (Exception exception) {
                    this.logger.info("Error while adding subfolders of " + folder.getUri(), (Throwable)exception);
                }
            }
            dispatch2 = arrayList.iterator();
            while (!this.stopRequested && dispatch2.hasNext()) {
                OutlookResource.Folder folder2 = (OutlookResource.Folder)dispatch2.next();
                dispatch2.remove();
                try {
                    this.crawlContainer(folder2, folder);
                }
                catch (Exception exception) {
                    this.logger.info("Error while adding subfolders of " + folder.getUri(), (Throwable)exception);
                }
                finally {
                    folder2.release();
                }
            }
            if (arrayList.isEmpty() && n <= n2) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (!arrayList.isEmpty()) {
                for (OutlookResource.Folder folder2 : arrayList) {
                    try {
                        folder2.release();
                    }
                    catch (Exception exception) {
                        this.logger.info("Error releasing " + folder2, (Throwable)exception);
                    }
                }
            }
            dispatch.safeRelease();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean crawlSubItems(OutlookResource.Folder folder) {
        int n;
        Dispatch dispatch2 = folder.getResource();
        Dispatch dispatch = Dispatch.get((Dispatch)dispatch2, (String)"Items").toDispatch();
        if (dispatch == null) {
            return true;
        }
        int n2 = Dispatch.get((Dispatch)dispatch, (String)"Count").toInt();
        if (n2 == 0) {
            return true;
        }
        try {
        }
        catch (Exception exception) {
            this.logger.warn("Error while adding subfolders of " + folder.getUri(), (Throwable)exception);
            return true;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        for (n = 1; !this.stopRequested && n <= n2; ++n) {
            OutlookResource outlookResource;
            Dispatch dispatch3 = Dispatch.invoke((Dispatch)dispatch, (String)"Item", (int)2, (Object[])new Object[]{new Integer(n)}, (int[])new int[1]).toDispatch();
            if (dispatch3 == null || (outlookResource = OutlookResource.createWrapperFor(this, dispatch3, this.logger)) == null) continue;
            try {
                this.crawlSingleResource(outlookResource, folder);
                continue;
            }
            finally {
                outlookResource.release();
            }
        }
        if (n <= n2) {
            boolean bl = false;
            dispatch.safeRelease();
            return bl;
        }
        return true;
    }

    protected void endCall() {
        this.outlookMapi.safeRelease();
        this.outlookMapi = null;
        this.outlookApp.safeRelease();
        this.outlookApp = null;
        this.accessor = null;
    }

    protected OutlookAccessor getAccessor() {
        if (this.accessor == null) {
            throw new RuntimeException("accessor is null, call to beginCall() missing.");
        }
        return this.accessor;
    }

    protected Dispatch getOutlookMapi() {
        if (this.outlookMapi == null) {
            throw new RuntimeException("outlook MAPI is null, call to beginCall() missing.");
        }
        return this.outlookMapi;
    }

    public String getUriPrefix() {
        return this.uriPrefix;
    }

    public boolean hasRedemption() {
        return this.hasRedemption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(URI uRI) throws IOException {
        this.logger.info("Outlook: opening uri " + uRI);
        this.beginCall();
        OutlookResource outlookResource = null;
        try {
            outlookResource = OutlookResource.createWrapperFor(this, uRI.toString(), this.logger);
            if (outlookResource == null) {
                throw new IOException("outlook: cannot found uri " + uRI);
            }
            try {
                Dispatch.call((Dispatch)outlookResource.getResource(), (String)"Display");
                try {
                    Dispatch.call((Dispatch)outlookResource.getResource(), (String)"Activate");
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                throw new IOException("outlook: unable to display uri: " + uRI + " reason: " + exception);
            }
        }
        finally {
            if (outlookResource != null) {
                outlookResource.release();
            }
            this.endCall();
        }
    }

    public void release() {
        System.gc();
        ComThread.quitMainSTA();
    }

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.uriPrefix = ((OutlookDataSource)dataSource).getRootUrl();
        if (this.uriPrefix == null) {
            this.uriPrefix = "outlook://";
            this.logger.warn("Outlook adapter missing the rootUrl property. Using " + this.uriPrefix + " instead.");
        } else {
            this.logger.info("crawling outlook, uri prefix: " + this.uriPrefix);
        }
        this.boundaries = ConfigurationUtil.getDomainBoundaries(dataSource.getConfiguration());
    }

    public static class OLConst {
        public static final int olAppointmentItem = 1;
        public static final int olFolderCalendar = 9;
        public static final int olFolderContacts = 10;
    }
}

