/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.util.UUID;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Resource;

public final class UriUtil {
    private static final String ESCAPE_CHARS = "<>%\"{}|\\^[]`";

    public static String encodeUri(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        UriUtil.encodeUri(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void encodeUri(String string, StringBuilder stringBuilder) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = c = string.charAt(i);
            if (ESCAPE_CHARS.indexOf(c) >= 0 || c2 <= ' ') {
                stringBuilder.append('%');
                String string2 = Integer.toHexString(c2);
                if (string2.length() == 1) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(c);
        }
    }

    public static String decodeUri(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        UriUtil.decodeUri(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void decodeUri(String string, StringBuilder stringBuilder) {
        int n = string.indexOf(37);
        int n2 = 0;
        while (n != -1) {
            stringBuilder.append(string.substring(n2, n));
            String string2 = string.substring(n + 1, n + 3);
            stringBuilder.append((char)Integer.parseInt(string2, 16));
            n2 = n + 3;
            n = string.indexOf(37, n2);
        }
        stringBuilder.append(string.substring(n2));
    }

    public static Resource generateRandomResource(Model model) {
        return model.createURI("urn:uuid:" + UUID.randomUUID().toString());
    }
}

