/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.sikuli.api.FourCornerModel;
import org.sikuli.api.ModelPart;
import org.sikuli.core.draw.ImageRenderer;
import org.sikuli.core.draw.PiccoloImageRenderer;
import org.sikuli.core.logging.ImageExplainer;
import org.sikuli.core.search.TemplateMatcher;

class VisualModelFinder {
    static final ImageExplainer logger = ImageExplainer.getExplainer(VisualModelFinder.class);

    VisualModelFinder() {
    }

    public static List<TemplateMatcher.Result> searchButton(FourCornerModel model, BufferedImage testImage) {
        double minSimilarity = 0.7;
        int numMatches = 40;
        final List tms1 = TemplateMatcher.findMatchesByGrayscaleAtOriginalResolution((BufferedImage)testImage, (BufferedImage)model.getTopLeft().getImage(), (int)numMatches, (double)minSimilarity);
        final List tms3 = TemplateMatcher.findMatchesByGrayscaleAtOriginalResolution((BufferedImage)testImage, (BufferedImage)model.getBottomRight().getImage(), (int)numMatches, (double)minSimilarity);
        final List tms2 = TemplateMatcher.findMatchesByGrayscaleAtOriginalResolution((BufferedImage)testImage, (BufferedImage)model.getTopRight().getImage(), (int)numMatches, (double)minSimilarity);
        final List tms4 = TemplateMatcher.findMatchesByGrayscaleAtOriginalResolution((BufferedImage)testImage, (BufferedImage)model.getBottomLeft().getImage(), (int)numMatches, (double)minSimilarity);
        PiccoloImageRenderer matchedPartsRenderer = new PiccoloImageRenderer(testImage){

            protected void addContent(PLayer layer) {
                for (List tmss : Lists.newArrayList((Object[])new List[]{tms1, tms2, tms3, tms4})) {
                    for (TemplateMatcher.Result tms : tmss) {
                        PPath c = PPath.createRectangle((float)tms.getX(), (float)tms.getY(), (float)tms.getWidth(), (float)tms.getHeight());
                        c.setStroke((Stroke)new BasicStroke(2.0f));
                        c.setStrokePaint((Paint)Color.blue);
                        c.setTransparency(0.5f);
                        layer.addChild((PNode)c);
                    }
                }
            }
        };
        logger.step((ImageRenderer)matchedPartsRenderer, (Object)"matched parts");
        final ArrayList hypotheses = Lists.newArrayList();
        for (TemplateMatcher.Result scoreMatch1 : tms1) {
            for (TemplateMatcher.Result scoreMatch3 : tms3) {
                ModelPartMatch m2;
                ModelPartMatch m1 = new ModelPartMatch(model.getTopLeft(), scoreMatch1);
                MatchHypothesis newHypothesis = new MatchHypothesis(m1, m2 = new ModelPartMatch(model.getBottomRight(), scoreMatch3));
                if (!newHypothesis.isValid()) continue;
                hypotheses.add(newHypothesis);
            }
        }
        PiccoloImageRenderer hypothesesRenderer = new PiccoloImageRenderer(testImage){

            protected void addContent(PLayer layer) {
                for (MatchHypothesis h : hypotheses) {
                    ModelPartMatch m1 = h.getTopLeft();
                    ModelPartMatch m2 = h.getBottomRight();
                    TemplateMatcher.Result p1 = m1.getScoreMatch();
                    TemplateMatcher.Result p2 = m2.getScoreMatch();
                    PPath line = PPath.createLine((float)p1.getX(), (float)p1.getY(), (float)p2.getX(), (float)p2.getY());
                    line.setStroke((Stroke)new BasicStroke(2.0f));
                    line.setStrokePaint((Paint)Color.red);
                    layer.addChild((PNode)line);
                    Point p = h.getExpectedBottomLeftPartModelLocation();
                    PPath c = PPath.createRectangle((float)p.x, (float)p.y, (float)10.0f, (float)10.0f);
                    c.setStroke((Stroke)new BasicStroke(2.0f));
                    c.setStrokePaint((Paint)Color.green);
                    layer.addChild((PNode)c);
                    p = h.getExpectedTopRightPartModelLocation();
                    c = PPath.createRectangle((float)p.x, (float)p.y, (float)10.0f, (float)10.0f);
                    c.setStroke((Stroke)new BasicStroke(2.0f));
                    c.setStrokePaint((Paint)Color.green);
                    layer.addChild((PNode)c);
                }
            }
        };
        logger.step((ImageRenderer)hypothesesRenderer, (Object)"hypotheses");
        block2: for (MatchHypothesis h1 : hypotheses) {
            boolean isMatchedPartSeenNearbyExpectedLocation;
            Point seenLocation;
            Point expectedLocation = h1.getExpectedTopRightPartModelLocation();
            for (TemplateMatcher.Result s2 : tms2) {
                seenLocation = s2.getLocation();
                isMatchedPartSeenNearbyExpectedLocation = seenLocation.distance(expectedLocation.x, expectedLocation.y) < 5.0;
                if (!isMatchedPartSeenNearbyExpectedLocation) continue;
                h1.setTopRight(new ModelPartMatch(model.getTopRight(), s2));
                break;
            }
            expectedLocation = h1.getExpectedBottomLeftPartModelLocation();
            for (TemplateMatcher.Result s4 : tms4) {
                seenLocation = s4.getLocation();
                isMatchedPartSeenNearbyExpectedLocation = seenLocation.distance(expectedLocation.x, expectedLocation.y) < 5.0;
                if (!isMatchedPartSeenNearbyExpectedLocation) continue;
                h1.setBottomLeft(new ModelPartMatch(model.getBottomLeft(), s4));
                continue block2;
            }
        }
        logger.step((ImageRenderer)new MatchHypotheseRenderer(testImage, hypotheses), (Object)"hypotheses + other matched parts");
        ArrayList goodHypotheses = Lists.newArrayList();
        for (MatchHypothesis h1 : hypotheses) {
            if (h1.getScore() != 4) continue;
            goodHypotheses.add(h1);
        }
        Collections.sort(goodHypotheses, new Comparator<MatchHypothesis>(){

            @Override
            public int compare(MatchHypothesis arg0, MatchHypothesis arg1) {
                return arg0.getBounds().width * arg0.getBounds().height - arg1.getBounds().width * arg1.getBounds().height;
            }
        });
        HashMap alreadyUsedMatch = Maps.newHashMap();
        ArrayList nonOverlappingGoodHypotheses = Lists.newArrayList();
        for (MatchHypothesis h1 : goodHypotheses) {
            if (alreadyUsedMatch.containsKey(h1.getTopLeft().getScoreMatch()) || alreadyUsedMatch.containsKey(h1.getBottomLeft().getScoreMatch()) || alreadyUsedMatch.containsKey(h1.getTopRight().getScoreMatch()) || alreadyUsedMatch.containsKey(h1.getBottomRight().getScoreMatch())) continue;
            nonOverlappingGoodHypotheses.add(h1);
            alreadyUsedMatch.put(h1.getTopLeft().getScoreMatch(), 1);
            alreadyUsedMatch.put(h1.getBottomLeft().getScoreMatch(), 1);
            alreadyUsedMatch.put(h1.getTopRight().getScoreMatch(), 1);
            alreadyUsedMatch.put(h1.getBottomRight().getScoreMatch(), 1);
        }
        logger.step((ImageRenderer)new MatchHypotheseRenderer(testImage, nonOverlappingGoodHypotheses), (Object)"non-overlapping good hypotheses");
        ArrayList matches = Lists.newArrayList();
        for (MatchHypothesis h1 : nonOverlappingGoodHypotheses) {
            TemplateMatcher.Result regionMatch = new TemplateMatcher.Result(h1.getBounds());
            matches.add(regionMatch);
        }
        return matches;
    }

    static class MatchHypotheseRenderer
    extends PiccoloImageRenderer
    implements ImageRenderer {
        private final List<MatchHypothesis> hypotheses;

        MatchHypotheseRenderer(BufferedImage testImage, List<MatchHypothesis> hypotheses) {
            super(testImage);
            this.hypotheses = hypotheses;
        }

        protected void addContent(PLayer layer) {
            for (MatchHypothesis h : this.hypotheses) {
                PPath c;
                ModelPartMatch m1 = h.getTopLeft();
                ModelPartMatch m2 = h.getBottomRight();
                TemplateMatcher.Result p1 = m1.getScoreMatch();
                TemplateMatcher.Result p2 = m2.getScoreMatch();
                Rectangle bs = h.getBounds();
                PPath rect = PPath.createRectangle((float)bs.x, (float)bs.y, (float)bs.width, (float)bs.height);
                rect.setStroke((Stroke)new BasicStroke(2.0f));
                rect.setStrokePaint((Paint)Color.red);
                rect.setPaint(null);
                layer.addChild((PNode)rect);
                ModelPartMatch m3 = h.getTopRight();
                ModelPartMatch m4 = h.getBottomLeft();
                if (m3 != null) {
                    TemplateMatcher.Result p3 = m3.getScoreMatch();
                    c = PPath.createRectangle((float)p3.getX(), (float)p3.getY(), (float)p3.getWidth(), (float)p3.getHeight());
                    c.setStroke((Stroke)new BasicStroke(2.0f));
                    c.setStrokePaint((Paint)Color.blue);
                    c.setTransparency(0.5f);
                    layer.addChild((PNode)c);
                }
                if (m4 == null) continue;
                TemplateMatcher.Result p4 = m4.getScoreMatch();
                c = PPath.createRectangle((float)p4.getX(), (float)p4.getY(), (float)p4.getWidth(), (float)p4.getHeight());
                c.setStroke((Stroke)new BasicStroke(2.0f));
                c.setStrokePaint((Paint)Color.green);
                c.setTransparency(0.5f);
                layer.addChild((PNode)c);
            }
        }
    }

    static class MatchHypothesis {
        private final ModelPartMatch topLeft;
        private final ModelPartMatch bottomRight;
        private ModelPartMatch topRight;
        private ModelPartMatch bottomLeft;

        public MatchHypothesis(ModelPartMatch topLeft, ModelPartMatch bottomRight) {
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        public ModelPartMatch getTopLeft() {
            return this.topLeft;
        }

        public ModelPartMatch getBottomRight() {
            return this.bottomRight;
        }

        public Point getLocation() {
            return this.topLeft.scoreMatch.getBounds().getLocation();
        }

        public boolean isValid() {
            boolean isLeftRight = this.topLeft.getScoreMatch().getX() < this.bottomRight.getScoreMatch().getX();
            boolean isTopDown = this.topLeft.getScoreMatch().getY() < this.bottomRight.getScoreMatch().getY();
            int modelHeight = this.bottomRight.getModelPart().getBounds().y - this.topLeft.getModelPart().getBounds().y;
            int hypothesisHeight = this.bottomRight.getScoreMatch().getY() - this.topLeft.getScoreMatch().getY();
            boolean isHeightSimilar = Math.abs(hypothesisHeight - modelHeight) < 5;
            return isHeightSimilar && isLeftRight && isTopDown;
        }

        public void setTopRight(ModelPartMatch topRight) {
            this.topRight = topRight;
        }

        public ModelPartMatch getTopRight() {
            return this.topRight;
        }

        public void setBottomLeft(ModelPartMatch bottomLeft) {
            this.bottomLeft = bottomLeft;
        }

        public ModelPartMatch getBottomLeft() {
            return this.bottomLeft;
        }

        public Point getExpectedTopRightPartModelLocation() {
            int x = this.bottomRight.getScoreMatch().getBounds().x;
            int y = this.topLeft.getScoreMatch().getBounds().y;
            return new Point(x, y);
        }

        public Point getExpectedBottomLeftPartModelLocation() {
            int x = this.topLeft.getScoreMatch().getBounds().x;
            int y = this.bottomRight.getScoreMatch().getBounds().y;
            return new Point(x, y);
        }

        public int getScore() {
            int score = 2;
            if (this.bottomLeft != null) {
                ++score;
            }
            if (this.topRight != null) {
                ++score;
            }
            return score;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.getLocation(), this.getSize());
        }

        public Dimension getSize() {
            return new Dimension(this.bottomRight.getScoreMatch().getX() + this.bottomRight.getScoreMatch().getWidth() - this.topLeft.getScoreMatch().getX(), this.bottomRight.getScoreMatch().getY() + this.bottomRight.getScoreMatch().getHeight() - this.topLeft.getScoreMatch().getY());
        }
    }

    static class ModelPartMatch {
        private final ModelPart modelPart;
        private final TemplateMatcher.Result scoreMatch;

        public ModelPartMatch(ModelPart modelPart, TemplateMatcher.Result scoreMatch) {
            this.modelPart = modelPart;
            this.scoreMatch = scoreMatch;
        }

        public TemplateMatcher.Result getScoreMatch() {
            return this.scoreMatch;
        }

        public ModelPart getModelPart() {
            return this.modelPart;
        }
    }
}

