/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessBean;
import javax.xml.namespace.QName;
import org.switchyard.component.bean.ClientProxyBean;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.deploy.CDIBeanServiceDescriptor;
import org.switchyard.transform.Transformer;

@ApplicationScoped
public class SwitchYardCDIServiceDiscovery
implements Extension {
    private BeanDeploymentMetaData _beanDeploymentMetaData;
    private List<ClientProxyBean> _createdProxyBeans = new ArrayList<ClientProxyBean>();

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeEvent) {
        this._beanDeploymentMetaData = BeanDeploymentMetaData.bind();
    }

    public void processBean(@Observes ProcessBean processBean, BeanManager beanManager) {
        Bean bean = processBean.getBean();
        Set injectionPoints = bean.getInjectionPoints();
        for (InjectionPoint injectionPoint : injectionPoints) {
            for (Annotation qualifier : injectionPoint.getQualifiers()) {
                Class<?> memberType;
                Member member;
                if (!Reference.class.isAssignableFrom(qualifier.annotationType()) || !((member = injectionPoint.getMember()) instanceof Field) || !(memberType = ((Field)member).getType()).isInterface()) continue;
                this.addInjectableClientProxyBean((Field)member, (Reference)qualifier, injectionPoint.getQualifiers(), beanManager);
            }
        }
        if (this.isServiceBean(bean)) {
            Class serviceType = bean.getBeanClass();
            Service serviceAnnotation = serviceType.getAnnotation(Service.class);
            this._beanDeploymentMetaData.addServiceDescriptor(new CDIBeanServiceDescriptor(bean, beanManager, this._beanDeploymentMetaData));
            if (serviceType.isInterface()) {
                this.addInjectableClientProxyBean(bean, serviceType, serviceAnnotation, beanManager);
            }
        }
        if (Transformer.class.isAssignableFrom(bean.getBeanClass())) {
            Class transformerRT = bean.getBeanClass();
            try {
                this._beanDeploymentMetaData.addTransformer((Transformer)transformerRT.newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Invalid Transformer implementation '" + transformerRT.getName() + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Invalid Transformer implementation '" + transformerRT.getName() + "'.", e);
            }
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterEvent) {
        for (ClientProxyBean proxyBean : this._createdProxyBeans) {
            afterEvent.addBean((Bean)proxyBean);
            this._beanDeploymentMetaData.addClientProxy(proxyBean);
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
        BeanDeploymentMetaData.unbind();
    }

    private void addInjectableClientProxyBean(Bean<?> serviceBean, Class<?> serviceType, Service serviceAnnotation, BeanManager beanManager) {
        QName serviceQName = this.toServiceQName(serviceType);
        this.addClientProxyBean(serviceQName, serviceType, null);
    }

    private void addInjectableClientProxyBean(Field injectionPointField, Reference serviceReference, Set<Annotation> qualifiers, BeanManager beanManager) {
        QName serviceQName = this.toServiceQName(injectionPointField.getType());
        this.addClientProxyBean(serviceQName, injectionPointField.getType(), qualifiers);
    }

    private void addClientProxyBean(QName serviceQName, Class<?> beanClass, Set<Annotation> qualifiers) {
        for (ClientProxyBean clientProxyBean : this._createdProxyBeans) {
            if (!serviceQName.equals(clientProxyBean.getServiceQName()) || beanClass != clientProxyBean.getBeanClass()) continue;
            return;
        }
        ClientProxyBean clientProxyBean = new ClientProxyBean(serviceQName, beanClass, qualifiers, this._beanDeploymentMetaData);
        this._createdProxyBeans.add(clientProxyBean);
    }

    private boolean isServiceBean(Bean<?> bean) {
        return bean.getBeanClass().isAnnotationPresent(Service.class);
    }

    private QName toServiceQName(Class<?> serviceType) {
        return new QName(serviceType.getSimpleName());
    }
}

