/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.deploy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.switchyard.component.bean.ClientProxyBean;
import org.switchyard.component.bean.deploy.ServiceDescriptor;
import org.switchyard.transform.Transformer;

public final class BeanDeploymentMetaData
implements Serializable {
    private static final String JAVA_COMP_SWITCHYARD_SERVICE_DESCRIPTOR_SET = "cn=SwitchyardApplicationServiceDescriptorSet";
    private ClassLoader _deploymentClassLoader;
    private List<ServiceDescriptor> _serviceDescriptors = new ArrayList<ServiceDescriptor>();
    private List<ClientProxyBean> _clientProxies = new ArrayList<ClientProxyBean>();
    private List<Transformer> _transformers = new ArrayList<Transformer>();

    private BeanDeploymentMetaData(ClassLoader deploymentClassLoader) {
        this._deploymentClassLoader = deploymentClassLoader;
    }

    public ClassLoader getDeploymentClassLoader() {
        return this._deploymentClassLoader;
    }

    public void addServiceDescriptor(ServiceDescriptor serviceDescriptor) {
        this._serviceDescriptors.add(serviceDescriptor);
    }

    public void addClientProxy(ClientProxyBean proxy) {
        this._clientProxies.add(proxy);
    }

    public void addTransformer(Transformer transformer) {
        this._transformers.add(transformer);
    }

    public List<ServiceDescriptor> getServiceDescriptors() {
        return Collections.unmodifiableList(this._serviceDescriptors);
    }

    public List<ClientProxyBean> getClientProxies() {
        return Collections.unmodifiableList(this._clientProxies);
    }

    public List<Transformer> getTransformers() {
        return Collections.unmodifiableList(this._transformers);
    }

    public static BeanDeploymentMetaData bind() {
        Map<ClassLoader, BeanDeploymentMetaData> metaDataMap = BeanDeploymentMetaData.getBeanDeploymentMetaDataMap();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        BeanDeploymentMetaData deploymentMetaData = new BeanDeploymentMetaData(contextClassLoader);
        metaDataMap.put(contextClassLoader, deploymentMetaData);
        return deploymentMetaData;
    }

    public static BeanDeploymentMetaData lookup() {
        return BeanDeploymentMetaData.getBeanDeploymentMetaDataMap().get(Thread.currentThread().getContextClassLoader());
    }

    public static void unbind() {
        BeanDeploymentMetaData.getBeanDeploymentMetaDataMap().remove(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Map<ClassLoader, BeanDeploymentMetaData> getBeanDeploymentMetaDataMap() {
        Map map;
        InitialContext jndiContext = new InitialContext();
        try {
            Map descriptorMap;
            map = descriptorMap = (Map)jndiContext.lookup(JAVA_COMP_SWITCHYARD_SERVICE_DESCRIPTOR_SET);
        }
        catch (Throwable throwable) {
            try {
                jndiContext.close();
                throw throwable;
            }
            catch (NamingException e1) {
                ConcurrentHashMap<ClassLoader, BeanDeploymentMetaData> concurrentHashMap;
                InitialContext jndiContext2 = new InitialContext();
                try {
                    ConcurrentHashMap<ClassLoader, BeanDeploymentMetaData> descriptorMap = new ConcurrentHashMap<ClassLoader, BeanDeploymentMetaData>();
                    jndiContext2.bind(JAVA_COMP_SWITCHYARD_SERVICE_DESCRIPTOR_SET, descriptorMap);
                    concurrentHashMap = descriptorMap;
                }
                catch (Throwable throwable2) {
                    try {
                        jndiContext2.close();
                        throw throwable2;
                    }
                    catch (NamingException e2) {
                        throw new IllegalStateException("Unexpected NamingException getting JNDI Context.", e2);
                    }
                }
                jndiContext2.close();
                return concurrentHashMap;
            }
        }
        jndiContext.close();
        return map;
    }
}

