/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.deploy;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.component.bean.ClientProxyBean;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.deploy.ServiceDescriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceInterface;

public class BeanComponentActivator
extends BaseActivator {
    private static final String BEAN_TYPE = "bean";
    private BeanDeploymentMetaData _beanDeploymentMetaData;
    private Map<QName, ComponentReferenceModel> _references = new HashMap<QName, ComponentReferenceModel>();

    public BeanComponentActivator() {
        super(new String[]{BEAN_TYPE});
    }

    public ExchangeHandler init(QName name, Model config) {
        this.lookupBeanMetaData();
        if (config instanceof ComponentReferenceModel) {
            this._references.put(name, (ComponentReferenceModel)config);
            return null;
        }
        if (config instanceof ComponentServiceModel) {
            for (ServiceDescriptor descriptor : this._beanDeploymentMetaData.getServiceDescriptors()) {
                if (!descriptor.getServiceName().equals(name)) continue;
                return descriptor.getHandler();
            }
        }
        throw new SwitchYardException("Unknown Service name '" + name + "'.");
    }

    public void lookupBeanMetaData() {
        this._beanDeploymentMetaData = BeanDeploymentMetaData.lookupBeanDeploymentMetaData();
    }

    public ServiceInterface buildServiceInterface(QName name) {
        for (ServiceDescriptor descriptor : this._beanDeploymentMetaData.getServiceDescriptors()) {
            if (!descriptor.getServiceName().equals(name)) continue;
            return descriptor.getInterface();
        }
        throw new SwitchYardException("Unknown Service name '" + name + "'.");
    }

    public void start(ServiceReference service) {
        for (ClientProxyBean proxyBean : this._beanDeploymentMetaData.getClientProxies()) {
            if (!proxyBean.getServiceQName().equals(service.getName())) continue;
            proxyBean.setService(service);
        }
    }

    public void stop(ServiceReference service) {
    }

    public void destroy(ServiceReference service) {
        this._references.remove(service.getName());
    }
}

