/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.config.model;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.component.bean.config.model.v1.V1BeanComponentImplementationModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceInterfaceModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceInterfaceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentReferenceModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1JavaComponentReferenceInterfaceModel;
import org.switchyard.config.model.composite.v1.V1JavaComponentServiceInterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;

public class BeanSwitchYardScanner
implements Scanner<SwitchYardModel> {
    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel();
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getName());
        switchyardModel.setComposite((CompositeModel)compositeModel);
        List<Class<?>> serviceClasses = this.scanForServiceBeans(input.getURLs());
        for (Class<?> serviceClass : serviceClasses) {
            if (serviceClass.isInterface() || Modifier.isAbstract(serviceClass.getModifiers())) continue;
            V1ComponentModel componentModel = new V1ComponentModel();
            Service service = serviceClass.getAnnotation(Service.class);
            if (service == null) continue;
            V1BeanComponentImplementationModel beanModel = new V1BeanComponentImplementationModel();
            beanModel.setClazz(serviceClass.getName());
            componentModel.setImplementation((ComponentImplementationModel)beanModel);
            Class<?> iface = service.value();
            V1ComponentServiceModel serviceModel = new V1ComponentServiceModel();
            V1JavaComponentServiceInterfaceModel csiModel = new V1JavaComponentServiceInterfaceModel();
            String name = service.name().equals("") ? iface.getSimpleName() : service.name();
            serviceModel.setName(name);
            serviceModel.setInterface((ComponentServiceInterfaceModel)csiModel);
            csiModel.setInterface(iface.getName());
            componentModel.addService((ComponentServiceModel)serviceModel);
            for (Class<?> reference : this.getReferences(serviceClass)) {
                V1ComponentReferenceModel referenceModel = new V1ComponentReferenceModel();
                V1JavaComponentReferenceInterfaceModel interfaceModel = new V1JavaComponentReferenceInterfaceModel();
                referenceModel.setName(reference.getSimpleName());
                referenceModel.setInterface((ComponentReferenceInterfaceModel)interfaceModel);
                interfaceModel.setInterface(reference.getCanonicalName());
                componentModel.addReference((ComponentReferenceModel)referenceModel);
            }
            compositeModel.addComponent((ComponentModel)componentModel);
            componentModel.setName(name);
            compositeModel.addComponent((ComponentModel)componentModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }

    private List<Class<?>> scanForServiceBeans(List<URL> urls) throws IOException {
        IsAnnotationPresentFilter filter = new IsAnnotationPresentFilter(Service.class);
        ClasspathScanner serviceScanner = new ClasspathScanner((Filter)filter);
        for (URL url : urls) {
            serviceScanner.scan(url);
        }
        return filter.getMatchedTypes();
    }

    private Set<Class<?>> getReferences(Class<?> serviceClass) {
        HashSet references = new HashSet();
        for (Field field : serviceClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Reference.class)) continue;
            references.add(field.getType());
        }
        return references;
    }
}

