/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.config.model;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.annotations.ManagedTransaction;
import org.switchyard.annotations.ManagedTransactionType;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.component.bean.config.model.v1.V1BeanComponentImplementationModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentReferenceModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.policy.TransactionPolicy;

public class BeanSwitchYardScanner
implements Scanner<SwitchYardModel> {
    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel();
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getName());
        List<Class<?>> serviceClasses = this.scanForServiceBeans(input.getURLs());
        for (Class<?> serviceClass : serviceClasses) {
            ManagedTransaction mta;
            if (serviceClass.isInterface() || Modifier.isAbstract(serviceClass.getModifiers())) continue;
            V1ComponentModel componentModel = new V1ComponentModel();
            V1ComponentServiceModel serviceModel = new V1ComponentServiceModel();
            String name = serviceClass.getSimpleName();
            V1BeanComponentImplementationModel beanModel = new V1BeanComponentImplementationModel();
            beanModel.setClazz(serviceClass.getName());
            componentModel.setImplementation((ComponentImplementationModel)beanModel);
            Service service = serviceClass.getAnnotation(Service.class);
            if (service != null) {
                Class<?> iface = service.value();
                V1InterfaceModel csiModel = new V1InterfaceModel("java");
                name = service.name().equals("") ? iface.getSimpleName() : service.name();
                serviceModel.setName(name);
                serviceModel.setInterface((InterfaceModel)csiModel);
                csiModel.setInterface(iface.getName());
                componentModel.addService((ComponentServiceModel)serviceModel);
            }
            if ((mta = serviceClass.getAnnotation(ManagedTransaction.class)) != null) {
                if (ManagedTransactionType.LOCAL.equals((Object)mta.value())) {
                    serviceModel.addPolicyRequirement(TransactionPolicy.SUSPEND.toString());
                } else if (ManagedTransactionType.SHARED.equals((Object)mta.value())) {
                    serviceModel.addPolicyRequirement(TransactionPolicy.PROPAGATE.toString());
                }
            }
            for (Field field : this.getReferences(serviceClass)) {
                Class<?> reference = field.getType();
                V1ComponentReferenceModel referenceModel = new V1ComponentReferenceModel();
                V1InterfaceModel interfaceModel = new V1InterfaceModel("java");
                if (field.getAnnotation(Reference.class) != null) {
                    Reference ref = field.getAnnotation(Reference.class);
                    if (ref.value() == null || "".equals(ref.value())) {
                        referenceModel.setName(reference.getSimpleName());
                    } else {
                        QName qname = QName.valueOf(ref.value());
                        referenceModel.setName(qname.getLocalPart());
                    }
                } else {
                    referenceModel.setName(reference.getSimpleName());
                }
                referenceModel.setInterface((InterfaceModel)interfaceModel);
                interfaceModel.setInterface(reference.getCanonicalName());
                if (mta != null) {
                    if (ManagedTransactionType.LOCAL.equals((Object)mta.value())) {
                        referenceModel.addPolicyRequirement(TransactionPolicy.SUSPEND.toString());
                    } else if (ManagedTransactionType.SHARED.equals((Object)mta.value())) {
                        referenceModel.addPolicyRequirement(TransactionPolicy.PROPAGATE.toString());
                    }
                }
                componentModel.addReference((ComponentReferenceModel)referenceModel);
            }
            compositeModel.addComponent((ComponentModel)componentModel);
            componentModel.setName(name);
            compositeModel.addComponent((ComponentModel)componentModel);
        }
        if (!compositeModel.getModelChildren().isEmpty()) {
            switchyardModel.setComposite((CompositeModel)compositeModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }

    private List<Class<?>> scanForServiceBeans(List<URL> urls) throws IOException {
        IsAnnotationPresentFilter filter = new IsAnnotationPresentFilter(Service.class);
        filter.addType(Reference.class);
        ClasspathScanner serviceScanner = new ClasspathScanner((Filter)filter);
        for (URL url : urls) {
            serviceScanner.scan(url);
        }
        return filter.getMatchedTypes();
    }

    private Set<Field> getReferences(Class<?> serviceClass) {
        HashSet<Field> references = new HashSet<Field>();
        for (Field field : serviceClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Reference.class)) continue;
            references.add(field);
        }
        return references;
    }
}

