/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessBean;
import org.apache.log4j.Logger;
import org.switchyard.common.type.Classes;
import org.switchyard.component.bean.ClientProxyBean;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaDataCDIBean;
import org.switchyard.component.bean.deploy.CDIBean;
import org.switchyard.component.bean.deploy.CDIBeanServiceDescriptor;
import org.switchyard.component.bean.internal.context.ContextBean;

@ApplicationScoped
public class SwitchYardCDIServiceDiscovery
implements Extension {
    private static Logger _logger = Logger.getLogger(SwitchYardCDIServiceDiscovery.class);
    private BeanDeploymentMetaData _beanDeploymentMetaData;
    private List<ClientProxyBean> _createdProxyBeans = new ArrayList<ClientProxyBean>();

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeEvent, BeanManager beanManager) {
        _logger.debug((Object)"CDI Bean discovery process started.");
        this._beanDeploymentMetaData = new BeanDeploymentMetaData();
        this._beanDeploymentMetaData.setBeanManager(beanManager);
        this._beanDeploymentMetaData.setDeploymentClassLoader(Classes.getTCCL());
    }

    public void processBean(@Observes ProcessBean processBean, BeanManager beanManager) {
        Bean bean = processBean.getBean();
        Set injectionPoints = bean.getInjectionPoints();
        for (InjectionPoint injectionPoint : injectionPoints) {
            for (Annotation qualifier : injectionPoint.getQualifiers()) {
                Class<?> memberType;
                Member member;
                if (!Reference.class.isAssignableFrom(qualifier.annotationType()) || !((member = injectionPoint.getMember()) instanceof Field) || !(memberType = ((Field)member).getType()).isInterface()) continue;
                this.addInjectableClientProxyBean((Field)member, (Reference)qualifier, injectionPoint.getQualifiers(), beanManager);
            }
        }
        CDIBean cdiBean = new CDIBean(bean, beanManager);
        if (this.isServiceBean(bean)) {
            _logger.debug((Object)("Adding ServiceDescriptor for bean " + bean.getBeanClass().getName()));
            this._beanDeploymentMetaData.addServiceDescriptor(new CDIBeanServiceDescriptor(cdiBean, this._beanDeploymentMetaData));
        }
        this._beanDeploymentMetaData.addDeploymentBean(cdiBean);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterEvent) {
        for (ClientProxyBean proxyBean : this._createdProxyBeans) {
            _logger.debug((Object)("Adding ClientProxyBean for bean Service " + proxyBean.getServiceName() + ".  Service Interface type is " + proxyBean.getServiceInterface().getName()));
            afterEvent.addBean((Bean)proxyBean);
            this._beanDeploymentMetaData.addClientProxy(proxyBean);
        }
        afterEvent.addBean((Bean)new BeanDeploymentMetaDataCDIBean(this._beanDeploymentMetaData));
        afterEvent.addBean((Bean)new ContextBean());
        _logger.debug((Object)"CDI Bean discovery process completed.");
    }

    private void addInjectableClientProxyBean(Field injectionPointField, Reference serviceReference, Set<Annotation> qualifiers, BeanManager beanManager) {
        String serviceName = serviceReference.value().length() > 0 ? serviceReference.value() : injectionPointField.getType().getSimpleName();
        this.addClientProxyBean(serviceName, injectionPointField.getType(), qualifiers);
    }

    private void addClientProxyBean(String serviceName, Class<?> beanClass, Set<Annotation> qualifiers) {
        for (ClientProxyBean clientProxyBean : this._createdProxyBeans) {
            if (!serviceName.equals(clientProxyBean.getServiceName()) || beanClass != clientProxyBean.getBeanClass()) continue;
            return;
        }
        ClientProxyBean clientProxyBean = new ClientProxyBean(serviceName, beanClass, qualifiers, this._beanDeploymentMetaData);
        this._createdProxyBeans.add(clientProxyBean);
    }

    private boolean isServiceBean(Bean<?> bean) {
        Class beanClass = bean.getBeanClass();
        return Modifier.isPublic(beanClass.getModifiers()) && beanClass.isAnnotationPresent(Service.class);
    }
}

