/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceReference;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.component.bean.BeanComponentException;
import org.switchyard.component.bean.BeanServiceMetadata;
import org.switchyard.component.bean.ClientProxyBean;
import org.switchyard.component.bean.Invocation;
import org.switchyard.component.bean.Property;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.internal.context.ContextProxy;
import org.switchyard.component.bean.internal.message.MessageProxy;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class ServiceProxyHandler
implements ServiceHandler {
    private static Logger _logger = Logger.getLogger(ServiceProxyHandler.class);
    private Object _serviceBean;
    private BeanServiceMetadata _serviceMetadata;
    private BeanDeploymentMetaData _beanDeploymentMetaData;
    private Map<String, ServiceReference> _references = new HashMap<String, ServiceReference>();

    public ServiceProxyHandler(Object serviceBean, BeanServiceMetadata serviceMetadata, BeanDeploymentMetaData beanDeploymentMetaData) {
        this._serviceBean = serviceBean;
        this._serviceMetadata = serviceMetadata;
        this._beanDeploymentMetaData = beanDeploymentMetaData;
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        this.handle(exchange);
    }

    public void handleFault(Exchange exchange) {
    }

    public void addReference(ServiceReference reference) {
        this._references.put(reference.getName().getLocalPart(), reference);
    }

    public void injectImplementationProperties(PropertyResolver resolver) {
        for (Field field : this._serviceBean.getClass().getDeclaredFields()) {
            Object property;
            Property propAnno = field.getAnnotation(Property.class);
            if (propAnno == null || (property = resolver.resolveProperty(propAnno.name())) == null) continue;
            if (field.getType().isAssignableFrom(property.getClass())) {
                new FieldAccess(field).write(this._serviceBean, property);
                continue;
            }
            _logger.warn((Object)("Property '" + propAnno.name() + "' has incompatible type: Bean '" + this._serviceMetadata.getServiceClass().getName() + "' is expecting '" + field.getType().getName() + "', but was '" + property.getClass().getName() + "'. ignoring..."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handle(Exchange exchange) throws BeanComponentException {
        Invocation invocation = this._serviceMetadata.getInvocation(exchange);
        if (invocation == null) throw new SwitchYardException("Unexpected error.  BeanServiceMetadata should return an Invocation instance, or throw a BeanComponentException.");
        ExchangePattern exchangePattern = exchange.getContract().getProviderOperation().getExchangePattern();
        try {
            Object responseObject;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("CDI Bean Service ExchangeHandler proxy class received " + exchangePattern + " Exchange (" + System.identityHashCode(exchange) + ") for Bean Service '" + exchange.getProvider().getName() + "'.  Invoking bean method '" + invocation.getMethod().getName() + "'."));
            }
            ContextProxy.setContext(exchange.getContext());
            MessageProxy.setMessage(exchange.getMessage());
            try {
                responseObject = invocation.getMethod().invoke(this._serviceBean, invocation.getArgs());
            }
            finally {
                ContextProxy.setContext(null);
                MessageProxy.setMessage(null);
            }
            if (exchangePattern != ExchangePattern.IN_OUT) return;
            Message message = exchange.createMessage();
            message.setContent(responseObject);
            exchange.send(message);
            return;
        }
        catch (Exception ex) {
            String errMsg = "Invocation of operation '" + invocation.getMethod().getName() + "' on bean component '" + this._serviceBean.getClass().getName() + "failed.";
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)errMsg, (Throwable)ex);
            }
            Throwable faultContent = ex;
            if (exchangePattern != ExchangePattern.IN_OUT) throw new BeanComponentException(faultContent);
            if (faultContent instanceof InvocationTargetException) {
                faultContent = ((InvocationTargetException)ex).getTargetException();
            }
            for (Class<?> expectedFault : invocation.getMethod().getExceptionTypes()) {
                if (!expectedFault.isAssignableFrom(faultContent.getClass())) continue;
                exchange.sendFault(exchange.createMessage().setContent((Object)faultContent));
                return;
            }
            throw new BeanComponentException(faultContent);
        }
    }

    public void start() {
        for (ClientProxyBean proxyBean : this._beanDeploymentMetaData.getClientProxies()) {
            if (!this._references.containsKey(proxyBean.getServiceName())) continue;
            proxyBean.setService(this._references.get(proxyBean.getServiceName()));
        }
    }

    public void stop() {
    }
}

