/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangeState;
import org.switchyard.ServiceReference;
import org.switchyard.component.bean.BeanComponentException;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.extensions.java.JavaService;

public class ClientProxyBean
implements Bean {
    private String _serviceName;
    private ServiceReference _service;
    private Class<?> _serviceInterface;
    private Set<Annotation> _qualifiers;
    private Object _proxyBean;

    public ClientProxyBean(String serviceName, Class<?> proxyInterface, Set<Annotation> qualifiers, BeanDeploymentMetaData beanDeploymentMetaData) {
        this._serviceName = serviceName;
        this._serviceInterface = proxyInterface;
        if (qualifiers != null) {
            this._qualifiers = qualifiers;
        } else {
            this._qualifiers = new HashSet<Annotation>();
            this._qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
            this._qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
        }
        this._proxyBean = Proxy.newProxyInstance(beanDeploymentMetaData.getDeploymentClassLoader(), new Class[]{this._serviceInterface}, (InvocationHandler)new ClientProxyInvocationHandler(this._serviceInterface));
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public Class<?> getServiceInterface() {
        return this._serviceInterface;
    }

    public void setService(ServiceReference service) {
        this._service = service;
    }

    public Set<Type> getTypes() {
        HashSet<Type> types = new HashSet<Type>();
        types.add(this._serviceInterface);
        types.add((Type)((Object)Object.class));
        return types;
    }

    public Set<Annotation> getQualifiers() {
        return this._qualifiers;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Class<?> getBeanClass() {
        return this._serviceInterface;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public Object create(CreationalContext creationalContext) {
        return this._proxyBean;
    }

    public void destroy(Object instance, CreationalContext creationalContext) {
    }

    private class ClientProxyInvocationHandler
    implements InvocationHandler {
        private JavaService _invokerInterface;

        public ClientProxyInvocationHandler(Class<?> invokerInterface) {
            this._invokerInterface = JavaService.fromClass(invokerInterface);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (ClientProxyBean.this._service == null) {
                throw new BeanComponentException("A service reference to service '" + ClientProxyBean.this._serviceName + "' is not bound into " + "this client proxy instance.  A reference configuration to the service may be required in the application configuration.");
            }
            if (method.getReturnType() != null && !Void.TYPE.isAssignableFrom(method.getReturnType())) {
                SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
                Exchange exchangeIn = this.createExchange(ClientProxyBean.this._service, method, (ExchangeHandler)inOutHandler);
                if (args != null && args.length == 1) {
                    exchangeIn.send(exchangeIn.createMessage().setContent(args[0]));
                } else {
                    exchangeIn.send(exchangeIn.createMessage().setContent((Object)args));
                }
                Exchange exchangeOut = inOutHandler.waitForOut();
                if (exchangeOut.getState() == ExchangeState.OK) {
                    return exchangeOut.getMessage().getContent(method.getReturnType());
                }
                Object exceptionObj = exchangeOut.getMessage().getContent();
                if (exceptionObj instanceof Throwable) {
                    if (exceptionObj instanceof BeanComponentException) {
                        BeanComponentException beanCompException = (BeanComponentException)((Object)exceptionObj);
                        Throwable cause = beanCompException.getCause();
                        if (cause instanceof InvocationTargetException) {
                            throw cause.getCause();
                        }
                        throw cause;
                    }
                    throw (Throwable)exceptionObj;
                }
                throw new BeanComponentException("Bean Component invocation failure.  Service '" + ClientProxyBean.this._serviceName + "', operation '" + method.getName() + "'.").setFaultExchange(exchangeOut);
            }
            Exchange exchange = this.createExchange(ClientProxyBean.this._service, method, null);
            if (args == null) {
                exchange.send(exchange.createMessage());
            } else if (args.length == 1) {
                exchange.send(exchange.createMessage().setContent(args[0]));
            } else {
                exchange.send(exchange.createMessage().setContent((Object)args));
            }
            return null;
        }

        private Exchange createExchange(ServiceReference service, Method method, ExchangeHandler responseExchangeHandler) throws BeanComponentException {
            String operationName = method.getName();
            if (service.getInterface().getOperation(operationName) == null) {
                throw new BeanComponentException("Bean Component invocation failure.  Operation '" + operationName + "' is not defined on Service '" + ClientProxyBean.this._serviceName + "'.");
            }
            return service.createExchange(operationName, responseExchangeHandler);
        }
    }
}

