/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean;

import java.lang.reflect.Method;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.component.bean.BeanComponentException;

public class Invocation {
    private Method _method;
    private Exchange _exchange;
    private Object[] _args;

    Invocation(Method method, Exchange exchange) throws BeanComponentException {
        this._method = method;
        this._exchange = exchange;
        this._args = Invocation.castArg(method, exchange.getMessage());
        this.assertOK();
    }

    private void assertOK() throws BeanComponentException {
        this.assertMethodStructureSupported();
        this.assertTypesMatch();
    }

    public Object[] getArgs() {
        return this._args;
    }

    public Method getMethod() {
        return this._method;
    }

    private static Object[] castArg(Method method, Message message) {
        if (method.getParameterTypes().length == 1 && message != null) {
            return new Object[]{message.getContent(method.getParameterTypes()[0])};
        }
        return null;
    }

    private void assertMethodStructureSupported() throws BeanComponentException {
        Class<?>[] parameterTypes = this._method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new BeanComponentException("Bean service operation '" + this.operationName() + "' has more than 1 argument.  Bean component currently only supports single argument operations.");
        }
    }

    private void assertTypesMatch() throws BeanComponentException {
        if (this._args == null) {
            if (this._method.getParameterTypes().length != 0) {
                throw new BeanComponentException("Bean service operation '" + this.operationName() + "' requires a single argument.  Exchange payload specifies no payload.");
            }
        } else {
            Class<?> argType;
            if (this._args.length > 1) {
                throw new BeanComponentException("Bean service operation '" + this.operationName() + "' only supports a single argument.  Exchange payload specifies " + this._args.length + " args.");
            }
            if (this._args[0] != null && !(argType = this._method.getParameterTypes()[0]).isInstance(this._args[0])) {
                throw new BeanComponentException("Bean service operation '" + this.operationName() + "' requires a payload type of '" + argType.getName() + "'.  Actual payload type is '" + this._args[0].getClass().getName() + "'.  You must define and register a Transformer.");
            }
        }
    }

    private String operationName() {
        return this._exchange.getProvider().getName() + "#" + this._method.getName();
    }
}

