/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.deploy;

import javax.xml.namespace.QName;
import org.switchyard.SwitchYardException;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.component.bean.ClientProxyBean;
import org.switchyard.component.bean.ServiceProxyHandler;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.deploy.ServiceDescriptor;
import org.switchyard.component.bean.internal.ReferenceInvokerBean;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ComponentNames;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.metadata.ServiceInterface;

public class BeanComponentActivator
extends BaseActivator {
    public static final String BEAN_TYPE = "bean";
    private BeanDeploymentMetaData _beanDeploymentMetaData;

    public BeanComponentActivator() {
        super(new String[]{BEAN_TYPE});
    }

    public ServiceHandler activateService(QName serviceName, ComponentModel config) {
        this.lookupBeanMetaData();
        if (serviceName == null) {
            for (ComponentReferenceModel reference : config.getReferences()) {
                QName refName;
                for (ClientProxyBean proxyBean : this._beanDeploymentMetaData.getClientProxies()) {
                    if (!reference.getQName().getLocalPart().equals(proxyBean.getServiceName())) continue;
                    refName = ComponentNames.qualify((QName)config.getQName(), (QName)reference.getQName());
                    proxyBean.setService(this.getServiceDomain().getServiceReference(refName));
                }
                for (ReferenceInvokerBean invokerBean : this._beanDeploymentMetaData.getReferenceInvokers()) {
                    if (!reference.getQName().getLocalPart().equals(invokerBean.getServiceName())) continue;
                    refName = ComponentNames.qualify((QName)config.getQName(), (QName)reference.getQName());
                    invokerBean.setReference(this.getServiceDomain().getServiceReference(refName));
                }
            }
            return null;
        }
        PropertyResolver resolver = config.getModelConfiguration().getPropertyResolver();
        for (ServiceDescriptor descriptor : this._beanDeploymentMetaData.getServiceDescriptors()) {
            if (!descriptor.getServiceName().equals(serviceName.getLocalPart())) continue;
            ServiceProxyHandler handler = descriptor.getHandler();
            for (ComponentReferenceModel reference : config.getReferences()) {
                QName refName = ComponentNames.qualify((QName)config.getQName(), (QName)reference.getQName());
                handler.addReference(this.getServiceDomain().getServiceReference(refName));
            }
            handler.injectImplementationProperties(resolver);
            return handler;
        }
        throw new SwitchYardException("Unknown Service name '" + serviceName + "'.");
    }

    public void deactivateService(QName name, ServiceHandler handler) {
    }

    public void lookupBeanMetaData() {
        this._beanDeploymentMetaData = BeanDeploymentMetaData.lookupBeanDeploymentMetaData();
    }

    public ServiceInterface buildServiceInterface(String name) {
        for (ServiceDescriptor descriptor : this._beanDeploymentMetaData.getServiceDescriptors()) {
            if (!descriptor.getServiceName().equals(name)) continue;
            return descriptor.getInterface();
        }
        throw new SwitchYardException("Unknown Service name '" + name + "'.");
    }
}

