/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.deploy;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.riftsaw.engine.BPELEngine;
import org.riftsaw.engine.BPELEngineFactory;
import org.riftsaw.engine.ServiceLocator;
import org.riftsaw.engine.internal.BPELEngineImpl;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.component.bpel.config.model.BPELComponentImplementationModel;
import org.switchyard.component.bpel.exchange.BPELExchangeHandler;
import org.switchyard.component.bpel.exchange.BPELExchangeHandlerFactory;
import org.switchyard.component.bpel.riftsaw.RiftsawServiceLocator;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.exception.SwitchYardException;

public class BPELActivator
extends BaseActivator {
    private static final Logger LOG = Logger.getLogger(BPELActivator.class);
    private Map<QName, BPELExchangeHandler> _handlers = new HashMap<QName, BPELExchangeHandler>();
    private static BPELEngine _engine = null;

    public BPELActivator() {
        super(new String[]{"bpel"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        BPELActivator bPELActivator = this;
        synchronized (bPELActivator) {
            if (_engine == null) {
                _engine = BPELEngineFactory.getEngine();
                try {
                    RiftsawServiceLocator locator = new RiftsawServiceLocator(this.getServiceDomain());
                    Properties props = new Properties();
                    try {
                        InputStream is = BPELEngineImpl.class.getClassLoader().getResourceAsStream("bpel.properties");
                        props.load(is);
                    }
                    catch (Exception e) {
                        throw new SwitchYardException("Failed to load properties: " + e, (Throwable)e);
                    }
                    _engine.init((ServiceLocator)locator, props);
                }
                catch (Exception e) {
                    throw new SwitchYardException("Failed to initialize the engine: " + e, (Throwable)e);
                }
            }
        }
    }

    public ExchangeHandler init(QName qname, Model model) {
        this.init();
        if (model instanceof ComponentServiceModel) {
            BPELExchangeHandler handler = BPELExchangeHandlerFactory.instance().newBPELExchangeHandler(this.getServiceDomain());
            BPELComponentImplementationModel bciModel = null;
            if (!(((ComponentServiceModel)model).getComponent().getImplementation() instanceof BPELComponentImplementationModel)) {
                throw new SwitchYardException("Component is not BPEL");
            }
            bciModel = (BPELComponentImplementationModel)((ComponentServiceModel)model).getComponent().getImplementation();
            if (((ComponentServiceModel)model).getInterface() == null) {
                throw new SwitchYardException("Interface not defined for component with BPEL implementation");
            }
            handler.init(qname, bciModel, ((ComponentServiceModel)model).getInterface().getInterface(), _engine);
            this._handlers.put(qname, handler);
            return handler;
        }
        if (model instanceof ComponentReferenceModel) {
            ComponentReferenceModel crm = (ComponentReferenceModel)model;
            ((RiftsawServiceLocator)_engine.getServiceLocator()).initialiseReference(crm);
            return null;
        }
        throw new SwitchYardException("No BPEL component implementations found for service " + qname);
    }

    public void start(ServiceReference serviceRef) {
        BPELExchangeHandler handler = this._handlers.get(serviceRef.getName());
        if (handler != null) {
            handler.start(serviceRef);
        }
    }

    public void stop(ServiceReference serviceRef) {
        BPELExchangeHandler handler = this._handlers.get(serviceRef.getName());
        if (handler != null) {
            handler.stop(serviceRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(ServiceReference serviceRef) {
        BPELExchangeHandler handler = this._handlers.get(serviceRef.getName());
        if (handler != null) {
            try {
                handler.destroy(serviceRef);
            }
            finally {
                this._handlers.remove(serviceRef.getName());
            }
        }
        BPELActivator bPELActivator = this;
        synchronized (bPELActivator) {
            if (this._handlers.size() == 0 && _engine != null) {
                try {
                    _engine.close();
                    _engine = null;
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to close BPEL engine", (Throwable)e);
                }
            }
        }
    }
}

