/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.riftsaw;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.riftsaw.engine.BPELEngine;
import org.riftsaw.engine.DeploymentRef;
import org.riftsaw.engine.Fault;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceReference;
import org.switchyard.component.bpel.BPELFault;
import org.switchyard.component.bpel.config.model.BPELComponentImplementationModel;
import org.switchyard.component.bpel.exchange.BPELExchangeHandler;
import org.switchyard.component.bpel.riftsaw.WSDLHelper;
import org.switchyard.exception.SwitchYardException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RiftsawBPELExchangeHandler
extends BaseHandler
implements BPELExchangeHandler {
    private static final String VFS_SCHEME = "vfs";
    private static final String DEPLOY_XML = "deploy.xml";
    private static final Logger LOG = Logger.getLogger(RiftsawBPELExchangeHandler.class);
    private BPELEngine _engine = null;
    private QName _serviceName = null;
    private Definition _wsdl = null;
    private PortType _portType = null;
    private static Map<QName, QName> _serviceRefToCompositeMap = new HashMap<QName, QName>();
    private static Map<QName, DeploymentRef> _deployed = new HashMap<QName, DeploymentRef>();

    @Override
    public void init(QName qname, BPELComponentImplementationModel model, String intf, BPELEngine engine) {
        this._engine = engine;
        this._wsdl = WSDLHelper.getWSDLDefinition(intf);
        this._portType = WSDLHelper.getPortType(intf, this._wsdl);
        Service service = WSDLHelper.getServiceForPortType(this._portType, this._wsdl);
        this._serviceName = service.getQName();
        QName compositeName = model.getComponent().getComposite().getQName();
        if (!_serviceRefToCompositeMap.containsValue(compositeName)) {
            try {
                File deployFile = this.getDeployment();
                DeploymentRef ref = engine.deploy(this.getDeploymentName(), deployFile);
                _deployed.put(qname, ref);
            }
            catch (Exception e) {
                throw new SwitchYardException((Throwable)e);
            }
        }
        _serviceRefToCompositeMap.put(qname, compositeName);
    }

    private String getDeploymentName() throws Exception {
        String ret = null;
        URL url = Thread.currentThread().getContextClassLoader().getResource(DEPLOY_XML);
        if (url != null) {
            String urlpath = url.toString();
            int fileSeparatorIndex = (urlpath = urlpath.substring(0, urlpath.length() - DEPLOY_XML.length() - 1)).lastIndexOf(47);
            if (fileSeparatorIndex != -1) {
                ret = urlpath.substring(fileSeparatorIndex + 1);
                int suffixIndex = ret.lastIndexOf(46);
                if (suffixIndex != -1) {
                    ret = ret.substring(0, suffixIndex);
                }
            } else {
                LOG.error((Object)("Failed to obtain deployment name from URL: " + urlpath));
            }
        } else {
            LOG.error((Object)"Unable to locate deployment descriptor (deploy.xml) to derive deployment name");
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("Deployment name is: " + ret));
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getDeployment() throws Exception {
        File ret = null;
        URL url = Thread.currentThread().getContextClassLoader().getResource(DEPLOY_XML);
        int index = url.toString().indexOf(".jar");
        if (index != -1) {
            if (!url.getProtocol().equals(VFS_SCHEME)) throw new SwitchYardException("Unknown deployment environment");
            try {
                VirtualFile vfile = VFS.getChild((URI)url.toURI());
                List children = vfile.getParent().getChildrenRecursively();
                for (VirtualFile child : children) {
                    child.getPhysicalFile();
                }
                ret = vfile.getPhysicalFile().getParentFile();
            }
            catch (NoClassDefFoundError t) {
                LOG.error((Object)"Unable to resolve the deployment URL", (Throwable)t);
            }
        } else {
            ret = new File(url.toURI()).getParentFile();
        }
        if (!LOG.isDebugEnabled()) return ret;
        LOG.debug((Object)("Deployment=" + ret));
        return ret;
    }

    @Override
    public void start(ServiceReference serviceRef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("START: " + serviceRef));
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        Node request = (Node)exchange.getMessage().getContent(Node.class);
        HashMap headers = new HashMap();
        try {
            Operation operation = this._portType.getOperation(exchange.getContract().getServiceOperation().getName(), null, null);
            Element newreq = WSDLHelper.wrapRequestMessagePart((Element)request, operation);
            Element response = this._engine.invoke(this._serviceName, null, exchange.getContract().getServiceOperation().getName(), newreq, headers);
            if (exchange.getContract().getServiceOperation().getExchangePattern().equals((Object)ExchangePattern.IN_OUT)) {
                Message message = exchange.createMessage();
                message.setContent((Object)WSDLHelper.unwrapMessagePart(response));
                exchange.send(message);
            }
        }
        catch (Fault f) {
            SOAPFault fault = null;
            try {
                fault = SOAPFactory.newInstance().createFault("", f.getFaultName());
                Detail detail = fault.addDetail();
                Node cloned = detail.getOwnerDocument().importNode(WSDLHelper.unwrapMessagePart(f.getFaultMessage()), true);
                detail.appendChild(cloned);
            }
            catch (Exception e) {
                throw new HandlerException((Throwable)e);
            }
            throw new BPELFault(fault);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
    }

    @Override
    public void stop(ServiceReference serviceRef) {
        DeploymentRef ref;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("STOP: " + serviceRef));
        }
        if ((ref = _deployed.get(serviceRef.getName())) != null) {
            this._engine.undeploy(ref);
        }
        _serviceRefToCompositeMap.remove(serviceRef.getName());
    }

    @Override
    public void destroy(ServiceReference serviceRef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DESTROY: " + serviceRef));
        }
    }
}

