/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.riftsaw;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.riftsaw.engine.Fault;
import org.riftsaw.engine.Service;
import org.riftsaw.engine.ServiceLocator;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.component.bpel.config.model.BPELComponentImplementationModel;
import org.switchyard.component.bpel.riftsaw.WSDLHelper;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.exception.DeliveryException;
import org.switchyard.exception.SwitchYardException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RiftsawServiceLocator
implements ServiceLocator {
    private static final Logger LOG = Logger.getLogger(RiftsawServiceLocator.class);
    private static final long DEFAULT_TIMEOUT = 120000L;
    private Map<QName, ServiceDomain> _serviceDomains = new HashMap<QName, ServiceDomain>();
    private Map<QName, RegistryEntry> _registry = new HashMap<QName, RegistryEntry>();
    private long _waitTimeout = 120000L;

    public void addServiceDomain(QName serviceName, ServiceDomain serviceDomain) {
        this._serviceDomains.put(serviceName, serviceDomain);
    }

    public void removeServiceDomain(QName serviceName) {
        this._serviceDomains.remove(serviceName);
    }

    public ServiceDomain getServiceDomain(QName serviceName) {
        return this._serviceDomains.get(serviceName);
    }

    public Service getService(QName processName, QName serviceName, String portName) {
        int index = processName.getLocalPart().indexOf(45);
        QName localProcessName = new QName(null, processName.getLocalPart().substring(0, index));
        RegistryEntry re = this._registry.get(localProcessName);
        if (re == null) {
            LOG.error((Object)("No service references found for process '" + processName + "'"));
            return null;
        }
        Service ret = re.getService(serviceName, portName, this._serviceDomains.get(serviceName));
        if (ret == null) {
            LOG.error((Object)("No service found for '" + serviceName + "' (port " + portName + ")"));
        }
        return ret;
    }

    public void initialiseReference(ComponentReferenceModel crm) {
        RegistryEntry re;
        if (crm.getComponent() != null && crm.getComponent().getImplementation() instanceof BPELComponentImplementationModel) {
            BPELComponentImplementationModel impl = (BPELComponentImplementationModel)crm.getComponent().getImplementation();
            String local = impl.getProcess();
            String ns = null;
            int index = local.indexOf(58);
            if (index != -1) {
                local = local.substring(index + 1);
            }
            QName processName = new QName(ns, local);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Register reference " + crm.getName() + " (" + crm.getQName() + ") for process " + processName));
            }
            if ((re = this._registry.get(processName)) == null) {
                re = new RegistryEntry();
                this._registry.put(processName, re);
            }
        } else {
            throw new SwitchYardException("Could not find BPEL implementation associated with reference");
        }
        Definition wsdl = WSDLHelper.getWSDLDefinition(crm.getInterface().getInterface());
        PortType portType = WSDLHelper.getPortType(crm.getInterface().getInterface(), wsdl);
        re.register(wsdl, portType.getQName(), crm.getQName());
    }

    public class ServiceProxy
    implements Service {
        private ServiceReference _serviceReference = null;
        private PortType _portType = null;

        public ServiceProxy(ServiceReference sref, PortType portType) {
            this._serviceReference = sref;
            this._portType = portType;
        }

        public Element invoke(String operationName, Element mesg, Map<String, Object> headers) throws Exception {
            mesg = WSDLHelper.unwrapMessagePart(mesg);
            SynchronousInOutHandler rh = new SynchronousInOutHandler();
            Exchange exchange = this._serviceReference.createExchange(operationName, (ExchangeHandler)rh);
            Message req = exchange.createMessage();
            req.setContent((Object)mesg);
            exchange.send(req);
            try {
                exchange = rh.waitForOut(RiftsawServiceLocator.this._waitTimeout);
            }
            catch (DeliveryException e) {
                throw new HandlerException("Timed out after " + RiftsawServiceLocator.this._waitTimeout + " ms waiting on synchronous response from target service '" + this._serviceReference.getName() + "'.");
            }
            Message resp = exchange.getMessage();
            if (resp == null) {
                throw new Exception("Response not returned from operation '" + operationName + "' on service: " + this._serviceReference.getName());
            }
            Element respelem = (Element)resp.getContent(Node.class);
            Operation operation = this._portType.getOperation(operationName, null, null);
            if (exchange.getState() == ExchangeState.FAULT) {
                QName faultCode = null;
                if (respelem instanceof SOAPFault) {
                    SOAPFault fault = (SOAPFault)respelem;
                    respelem = (Element)fault.getDetail().getFirstChild();
                    faultCode = fault.getFaultCodeAsQName();
                }
                Element newfault = WSDLHelper.wrapFaultMessagePart(respelem, operation, null);
                throw new Fault(faultCode, newfault);
            }
            Element newresp = WSDLHelper.wrapResponseMessagePart(respelem, operation);
            return newresp;
        }
    }

    public class RegistryEntry {
        private List<Definition> _wsdls = new Vector<Definition>();
        private List<QName> _portTypes = new Vector<QName>();
        private List<QName> _services = new Vector<QName>();

        public void register(Definition wsdl, QName portType, QName service) {
            this._wsdls.add(wsdl);
            this._portTypes.add(portType);
            this._services.add(service);
        }

        public Service getService(QName serviceName, String portName, ServiceDomain serviceDomain) {
            ServiceProxy ret = null;
            for (int i = 0; ret == null && i < this._wsdls.size(); ++i) {
                Port port;
                javax.wsdl.Service service = this._wsdls.get(i).getService(serviceName);
                if (service == null || (port = service.getPort(portName)) == null || !port.getBinding().getPortType().getQName().equals(this._portTypes.get(i))) continue;
                QName switchYardService = this._services.get(i);
                ServiceReference sref = RiftsawServiceLocator.this.getServiceDomain(switchYardService).getServiceReference(switchYardService);
                if (sref == null) {
                    LOG.error((Object)("No service found for '" + serviceName + "' (port " + portName + ")"));
                    return null;
                }
                ret = new ServiceProxy(sref, port.getBinding().getPortType());
            }
            return ret;
        }
    }
}

