/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.deploy;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.riftsaw.engine.BPELEngine;
import org.riftsaw.engine.BPELEngineFactory;
import org.riftsaw.engine.ServiceLocator;
import org.riftsaw.engine.internal.BPELEngineImpl;
import org.switchyard.component.bpel.config.model.BPELComponentImplementationModel;
import org.switchyard.component.bpel.exchange.BPELExchangeHandler;
import org.switchyard.component.bpel.exchange.BPELExchangeHandlerFactory;
import org.switchyard.component.bpel.riftsaw.RiftsawServiceLocator;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class BPELActivator
extends BaseActivator {
    private static final Logger LOG = Logger.getLogger(BPELActivator.class);
    private Map<QName, BPELExchangeHandler> _handlers = new HashMap<QName, BPELExchangeHandler>();
    private static BPELEngine _engine = null;
    private static Configuration _configuration = null;
    private static RiftsawServiceLocator locator = new RiftsawServiceLocator();

    public BPELActivator() {
        super(new String[]{"bpel"});
    }

    public ServiceHandler activateService(QName serviceName, ComponentModel config) {
        this.init();
        BPELExchangeHandler handler = BPELExchangeHandlerFactory.instance().newBPELExchangeHandler(this.getServiceDomain());
        BPELComponentImplementationModel bciModel = (BPELComponentImplementationModel)config.getImplementation();
        ComponentServiceModel service = null;
        for (ComponentServiceModel csm : config.getServices()) {
            if (!csm.getQName().equals(serviceName)) continue;
            service = csm;
            break;
        }
        if (service.getInterface() == null) {
            throw new SwitchYardException("Interface not defined for component with BPEL implementation");
        }
        for (ComponentReferenceModel crm : config.getReferences()) {
            locator.addServiceDomain(crm.getQName(), this.getServiceDomain());
            ((RiftsawServiceLocator)_engine.getServiceLocator()).initialiseReference(crm);
        }
        handler.init(serviceName, bciModel, service.getInterface().getInterface(), _engine);
        this._handlers.put(serviceName, handler);
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateService(QName name, ServiceHandler handler) {
        this._handlers.remove(name);
        Class<BPELActivator> clazz = BPELActivator.class;
        synchronized (BPELActivator.class) {
            if (this._handlers.size() == 0 && _engine != null) {
                try {
                    _engine.close();
                    _engine = null;
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to close BPEL engine", (Throwable)e);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected void setConfiguration(Configuration config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting configuration to: " + config));
        }
        _configuration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        Class<BPELActivator> clazz = BPELActivator.class;
        synchronized (BPELActivator.class) {
            if (_engine == null) {
                _engine = BPELEngineFactory.getEngine();
                try {
                    Properties props = new Properties();
                    try {
                        InputStream is = BPELEngineImpl.class.getClassLoader().getResourceAsStream("bpel.properties");
                        props.load(is);
                    }
                    catch (Exception e) {
                        throw new SwitchYardException("Failed to load default properties: " + e, (Throwable)e);
                    }
                    if (_configuration != null) {
                        for (Configuration child : _configuration.getChildren()) {
                            if (LOG.isDebugEnabled()) {
                                if (props.containsKey(child.getName())) {
                                    LOG.debug((Object)("Overriding BPEL property: " + child.getName() + " = " + child.getValue()));
                                } else {
                                    LOG.debug((Object)("Setting BPEL property: " + child.getName() + " = " + child.getValue()));
                                }
                            }
                            props.put(child.getName(), child.getValue());
                        }
                    }
                    _engine.init((ServiceLocator)locator, props);
                }
                catch (Exception e) {
                    throw new SwitchYardException("Failed to initialize the engine: " + e, (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

