/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.riftsaw;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.riftsaw.engine.Fault;
import org.riftsaw.engine.Service;
import org.riftsaw.engine.ServiceLocator;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.component.bpel.BPELFault;
import org.switchyard.component.bpel.config.model.BPELComponentImplementationModel;
import org.switchyard.component.bpel.riftsaw.WSDLHelper;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.exception.DeliveryException;
import org.switchyard.exception.SwitchYardException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RiftsawServiceLocator
implements ServiceLocator {
    private static final Logger LOG = Logger.getLogger(RiftsawServiceLocator.class);
    private static final long DEFAULT_TIMEOUT = 120000L;
    private Map<QName, ServiceDomain> _serviceDomains = new HashMap<QName, ServiceDomain>();
    private Map<QName, RegistryEntry> _registry = new HashMap<QName, RegistryEntry>();
    private long _waitTimeout = 120000L;

    public void addServiceDomain(QName serviceName, ServiceDomain serviceDomain) {
        this._serviceDomains.put(serviceName, serviceDomain);
    }

    public void removeServiceDomain(QName serviceName) {
        this._serviceDomains.remove(serviceName);
    }

    public ServiceDomain getServiceDomain(QName serviceName) {
        return this._serviceDomains.get(serviceName);
    }

    public Service getService(QName processName, QName serviceName, String portName) {
        int index = processName.getLocalPart().indexOf(45);
        QName localProcessName = new QName(processName.getNamespaceURI(), processName.getLocalPart().substring(0, index));
        RegistryEntry re = this._registry.get(localProcessName);
        if (re == null) {
            LOG.error((Object)("No service references found for process '" + localProcessName + "'"));
            return null;
        }
        Service ret = re.getService(serviceName, portName, this._serviceDomains.get(serviceName));
        if (ret == null) {
            LOG.error((Object)("No service found for '" + serviceName + "' (port " + portName + ")"));
        }
        return ret;
    }

    public void initialiseReference(ComponentReferenceModel crm) {
        RegistryEntry re;
        if (crm.getComponent() != null && crm.getComponent().getImplementation() instanceof BPELComponentImplementationModel) {
            BPELComponentImplementationModel impl = (BPELComponentImplementationModel)crm.getComponent().getImplementation();
            QName processName = impl.getProcessQName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Register reference " + crm.getName() + " (" + crm.getQName() + ") for process " + processName));
            }
            if ((re = this._registry.get(processName)) == null) {
                re = new RegistryEntry();
                this._registry.put(processName, re);
            }
        } else {
            throw new SwitchYardException("Could not find BPEL implementation associated with reference");
        }
        Definition wsdl = WSDLHelper.getWSDLDefinition(crm.getInterface().getInterface());
        PortType portType = WSDLHelper.getPortType(crm.getInterface().getInterface(), wsdl);
        re.register(portType, crm.getQName());
    }

    public class ServiceProxy
    implements Service {
        private ServiceReference _serviceReference = null;
        private PortType _portType = null;

        public ServiceProxy(ServiceReference sref, PortType portType) {
            this._serviceReference = sref;
            this._portType = portType;
        }

        public Element invoke(String operationName, Element mesg, Map<String, Object> headers) throws Exception {
            mesg = WSDLHelper.unwrapMessagePart(mesg);
            SynchronousInOutHandler rh = new SynchronousInOutHandler();
            Exchange exchange = this._serviceReference.createExchange(operationName, (ExchangeHandler)rh);
            Message req = exchange.createMessage();
            req.setContent((Object)mesg);
            if (headers != null) {
                Set<String> keys = headers.keySet();
                for (String key : keys) {
                    exchange.getContext().setProperty(key, headers.get(key), Scope.IN).addLabels(new String[]{EndpointLabel.SOAP.label()});
                }
            }
            exchange.send(req);
            try {
                exchange = rh.waitForOut(RiftsawServiceLocator.this._waitTimeout);
            }
            catch (DeliveryException e) {
                throw new HandlerException("Timed out after " + RiftsawServiceLocator.this._waitTimeout + " ms waiting on synchronous response from target service '" + this._serviceReference.getName() + "'.");
            }
            Message resp = exchange.getMessage();
            if (resp == null) {
                throw new Exception("Response not returned from operation '" + operationName + "' on service: " + this._serviceReference.getName());
            }
            if (resp.getContent() instanceof Exception && !(resp.getContent() instanceof BPELFault)) {
                throw (Exception)resp.getContent();
            }
            Element respelem = (Element)resp.getContent(Node.class);
            Operation operation = this._portType.getOperation(operationName, null, null);
            if (exchange.getState() == ExchangeState.FAULT) {
                QName faultCode = null;
                if (respelem instanceof SOAPFault) {
                    SOAPFault fault = (SOAPFault)respelem;
                    respelem = (Element)fault.getDetail().getFirstChild();
                    faultCode = fault.getFaultCodeAsQName();
                }
                Element newfault = WSDLHelper.wrapFaultMessagePart(respelem, operation, null);
                throw new Fault(faultCode, newfault);
            }
            Element newresp = WSDLHelper.wrapResponseMessagePart(respelem, operation);
            return newresp;
        }
    }

    public class RegistryEntry {
        private List<PortType> _portTypes = new Vector<PortType>();
        private List<QName> _services = new Vector<QName>();

        public void register(PortType portType, QName service) {
            this._portTypes.add(portType);
            this._services.add(service);
        }

        public Service getService(QName serviceName, String portName, ServiceDomain serviceDomain) {
            ServiceProxy ret = null;
            int count = this._services.size();
            for (int index = 0; index < count; ++index) {
                if (!serviceName.equals(this._services.get(index))) continue;
                ServiceReference sref = serviceDomain.getServiceReference(serviceName);
                if (sref == null) break;
                ret = new ServiceProxy(sref, this._portTypes.get(index));
                break;
            }
            if (ret == null) {
                LOG.error((Object)("No service found for '" + serviceName));
            }
            return ret;
        }
    }
}

