/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.riftsaw;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.exception.SwitchYardException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class WSDLHelper {
    private static final Logger LOG = Logger.getLogger(WSDLHelper.class);
    private static final String WSDL_PORTTYPE_PREFIX = "#wsdl.porttype(";

    private WSDLHelper() {
    }

    public static Definition getWSDLDefinition(String location) throws SwitchYardException {
        Definition ret = null;
        if (location == null) {
            throw new SwitchYardException("WSDL location has not been specified");
        }
        try {
            int index = location.indexOf(35);
            if (index != -1) {
                location = location.substring(0, index);
            }
            URL url = Thread.currentThread().getContextClassLoader().getResource(location);
            ret = WSDLFactory.newInstance().newWSDLReader().readWSDL(url.toString());
        }
        catch (Exception e) {
            throw new SwitchYardException("Failed to load WSDL '" + location + "'", (Throwable)e);
        }
        return ret;
    }

    public static PortType getPortType(String location, Definition wsdl) throws SwitchYardException {
        PortType ret = null;
        if (location == null) {
            throw new SwitchYardException("WSDL location has not been specified");
        }
        int index = location.indexOf(WSDL_PORTTYPE_PREFIX);
        if (index != -1) {
            String portTypeName = location.substring(index + WSDL_PORTTYPE_PREFIX.length(), location.length() - 1);
            ret = wsdl.getPortType(new QName(wsdl.getTargetNamespace(), portTypeName));
        }
        return ret;
    }

    public static Service getServiceForPortType(PortType portType, Definition wsdl) {
        Service ret = null;
        Iterator iter = wsdl.getServices().values().iterator();
        while (ret == null && iter.hasNext()) {
            ret = (Service)iter.next();
            Iterator ports = ret.getPorts().values().iterator();
            boolean f_found = false;
            while (!f_found && ports.hasNext()) {
                Port port = (Port)ports.next();
                if (port.getBinding().getPortType() != portType) continue;
                f_found = true;
            }
            if (f_found) continue;
            ret = null;
        }
        return ret;
    }

    public static Element unwrapMessagePart(Element content) {
        NodeList nl = content.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            NodeList nl2 = ((Element)nl.item(i)).getChildNodes();
            for (int j = 0; j < nl2.getLength(); ++j) {
                if (!(nl2.item(j) instanceof Element)) continue;
                return (Element)nl2.item(j);
            }
            return null;
        }
        return null;
    }

    public static Element wrapRequestMessagePart(Element content, Operation operation) {
        return WSDLHelper.wrapMessagePart(content, operation, operation.getInput().getMessage().getParts(), false);
    }

    public static Element wrapResponseMessagePart(Element content, Operation operation) {
        return WSDLHelper.wrapMessagePart(content, operation, operation.getOutput().getMessage().getParts(), false);
    }

    public static Element wrapFaultMessagePart(Element content, Operation operation, String faultName) {
        Map parts = null;
        if (faultName != null) {
            Fault fault = operation.getFault(faultName);
            if (fault == null) {
                throw new SwitchYardException("Unable to find fault '" + faultName + "' on " + "operation '" + operation.getName() + "'");
            }
            parts = fault.getMessage().getParts();
        } else {
            Iterator iter = operation.getFaults().values().iterator();
            while (parts == null && iter.hasNext()) {
                Part part;
                Fault fault = (Fault)iter.next();
                if (fault.getMessage().getParts().size() != 1 || (part = (Part)fault.getMessage().getParts().values().iterator().next()).getElementName() == null || !content.getLocalName().equals(part.getElementName().getLocalPart()) || !content.getNamespaceURI().equals(part.getElementName().getNamespaceURI())) continue;
                parts = fault.getMessage().getParts();
            }
        }
        return WSDLHelper.wrapMessagePart(content, operation, parts, true);
    }

    protected static Element wrapMessagePart(Element content, Operation operation, Map<?, ?> parts, boolean fault) {
        Element ret = content.getOwnerDocument().createElement("message");
        String partName = null;
        if (parts != null) {
            if (parts.size() != 1) {
                throw new SwitchYardException("Only expecting a single message part for operation '" + operation.getName() + "'");
            }
            partName = (String)parts.keySet().iterator().next();
        }
        if (partName == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No part found for operation: " + operation + " and content: " + content));
            }
            if (!fault) {
                throw new SwitchYardException("Unable to find part name for operation '" + operation.getName() + "'");
            }
            return content;
        }
        Element part = ret.getOwnerDocument().createElement(partName);
        ret.appendChild(part);
        part.appendChild(content);
        return ret;
    }
}

