/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.deploy;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.riftsaw.engine.BPELEngine;
import org.switchyard.SwitchYardException;
import org.switchyard.component.bpel.exchange.BPELExchangeHandler;
import org.switchyard.component.bpel.exchange.BPELExchangeHandlerFactory;
import org.switchyard.component.bpel.riftsaw.RiftsawServiceLocator;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.implementation.bpel.BPELComponentImplementationModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;

public class BPELActivator
extends BaseActivator {
    public static final String BPEL_TYPE = "bpel";
    private static final Logger LOG = Logger.getLogger(BPELActivator.class);
    private static Map<QName, BPELExchangeHandler> _handlers = new HashMap<QName, BPELExchangeHandler>();
    private BPELEngine _engine = null;
    private RiftsawServiceLocator _locator = null;
    private Properties _config = null;

    public BPELActivator(BPELEngine engine, RiftsawServiceLocator locator, Properties config) {
        super(new String[]{BPEL_TYPE});
        this._engine = engine;
        this._locator = locator;
        this._config = config;
    }

    public ServiceHandler activateService(QName serviceName, ComponentModel config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Activate service: " + serviceName + " config=" + config));
        }
        BPELExchangeHandler handler = BPELExchangeHandlerFactory.instance().newBPELExchangeHandler(this.getServiceDomain());
        BPELComponentImplementationModel bciModel = (BPELComponentImplementationModel)config.getImplementation();
        ComponentServiceModel service = null;
        for (ComponentServiceModel csm : config.getServices()) {
            if (!csm.getQName().equals(serviceName)) continue;
            service = csm;
            break;
        }
        if (service.getInterface() == null) {
            throw new SwitchYardException("Interface not defined for component with BPEL implementation");
        }
        for (ComponentReferenceModel crm : config.getReferences()) {
            this._locator.addServiceDomain(crm.getQName(), this.getServiceDomain());
            this._locator.initialiseReference(crm);
        }
        handler.init(serviceName, bciModel, service.getInterface().getInterface(), this._engine, this._config);
        _handlers.put(serviceName, handler);
        return handler;
    }

    public void deactivateService(QName name, ServiceHandler handler) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("De-activate service: " + name + " handler=" + handler));
        }
        _handlers.remove(name);
    }
}

