/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.deploy;

import java.io.InputStream;
import java.util.EventObject;
import java.util.Properties;
import org.apache.ode.bpel.evt.BpelEvent;
import org.jboss.logging.Logger;
import org.riftsaw.engine.BPELEngine;
import org.riftsaw.engine.BPELEngineFactory;
import org.riftsaw.engine.BPELEngineListener;
import org.riftsaw.engine.ServiceLocator;
import org.riftsaw.engine.internal.BPELEngineImpl;
import org.switchyard.ServiceDomain;
import org.switchyard.component.bpel.BPELLogger;
import org.switchyard.component.bpel.BPELMessages;
import org.switchyard.component.bpel.deploy.BPELActivator;
import org.switchyard.component.bpel.riftsaw.RiftsawServiceLocator;
import org.switchyard.config.Configuration;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.BaseComponent;

public class BPELComponent
extends BaseComponent {
    private static final Logger LOG = Logger.getLogger(BPELComponent.class);
    private static BPELEngine _engine = null;
    private static Properties _config = null;
    private static RiftsawServiceLocator _locator = new RiftsawServiceLocator();
    private static boolean _initialized = false;

    public BPELComponent() {
        super(new String[]{"bpel"});
        this.setName("BPELComponent");
    }

    public void init(Configuration config) {
        super.init(config);
        this.initConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initConfig() {
        if (_initialized) {
            return;
        }
        BPELLogger.ROOT_LOGGER.initBPELComponent();
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(BPELComponent.class.getClassLoader());
        try {
            BPELEngineFactory.setServiceLocator((ServiceLocator)_locator);
            _config = new Properties();
            try {
                InputStream is = BPELEngineImpl.class.getClassLoader().getResourceAsStream("bpel.properties");
                _config.load(is);
            }
            catch (Exception e) {
                throw BPELMessages.MESSAGES.failedToLoadDefaultProperties(e);
            }
            if (this.getConfig() != null) {
                for (Configuration child : this.getConfig().getChildren()) {
                    if (LOG.isDebugEnabled()) {
                        if (_config.containsKey(child.getName())) {
                            LOG.debug((Object)("Overriding BPEL property: " + child.getName() + " = " + child.getValue()));
                        } else {
                            LOG.debug((Object)("Setting BPEL property: " + child.getName() + " = " + child.getValue()));
                        }
                    }
                    _config.put(child.getName(), child.getValue());
                }
            }
            BPELEngineFactory.setConfig((Properties)_config);
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
        _initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BPELEngine getEngine(final ServiceDomain domain) {
        BPELComponent bPELComponent = this;
        synchronized (bPELComponent) {
            if (_engine == null) {
                this.initConfig();
                try {
                    _engine = BPELEngineFactory.getEngine();
                    _engine.register(new BPELEngineListener(){

                        public void onEvent(BpelEvent bpelEvent) {
                            domain.getEventPublisher().publish((EventObject)bpelEvent);
                        }
                    });
                }
                catch (Exception e) {
                    throw BPELMessages.MESSAGES.failedToInitializeTheEngine(e);
                }
            }
        }
        return _engine;
    }

    public void destroy() {
        super.destroy();
        BPELLogger.ROOT_LOGGER.destroyBPELComponent();
        if (_engine != null) {
            try {
                _engine.close();
                _engine = null;
            }
            catch (Exception e) {
                BPELLogger.ROOT_LOGGER.failedToCloseBPELEngine(e);
            }
        }
    }

    public Activator createActivator(ServiceDomain domain) {
        BPELEngine engine = null;
        if (domain != null) {
            engine = this.getEngine(domain);
        }
        BPELActivator activator = new BPELActivator(engine, _locator, _config);
        activator.setServiceDomain(domain);
        return activator;
    }
}

