/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.riftsaw;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import org.jboss.logging.Logger;
import org.riftsaw.engine.Fault;
import org.riftsaw.engine.Service;
import org.riftsaw.engine.ServiceLocator;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.component.bpel.BPELFault;
import org.switchyard.component.bpel.BPELLogger;
import org.switchyard.component.bpel.BPELMessages;
import org.switchyard.component.bpel.riftsaw.WSDLHelper;
import org.switchyard.component.common.DeliveryException;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.implementation.bpel.BPELComponentImplementationModel;
import org.switchyard.deploy.ComponentNames;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RiftsawServiceLocator
implements ServiceLocator {
    private static final Logger LOG = Logger.getLogger(RiftsawServiceLocator.class);
    private static final long DEFAULT_TIMEOUT = 120000L;
    private Map<QName, ServiceDomain> _serviceDomains = new HashMap<QName, ServiceDomain>();
    private Map<QName, RegistryEntry> _registry = new HashMap<QName, RegistryEntry>();
    private long _waitTimeout = 120000L;

    public void addServiceDomain(QName serviceName, ServiceDomain serviceDomain) {
        this._serviceDomains.put(serviceName, serviceDomain);
    }

    public void removeServiceDomain(QName serviceName) {
        this._serviceDomains.remove(serviceName);
    }

    public ServiceDomain getServiceDomain(QName serviceName) {
        return this._serviceDomains.get(serviceName);
    }

    public Service getService(QName processName, QName serviceName, String portName) {
        int index = processName.getLocalPart().indexOf(45);
        QName localProcessName = new QName(processName.getNamespaceURI(), processName.getLocalPart().substring(0, index));
        RegistryEntry re = this._registry.get(localProcessName);
        if (re == null) {
            BPELLogger.ROOT_LOGGER.noServiceReferencesFoundForProcess(localProcessName.toString());
            return null;
        }
        Service ret = re.getService(serviceName, portName, this._serviceDomains.get(serviceName));
        if (ret == null) {
            BPELLogger.ROOT_LOGGER.noServiceFoundFor(serviceName.toString(), portName);
        }
        return ret;
    }

    public void initialiseReference(ComponentReferenceModel crm) {
        RegistryEntry re;
        if (crm.getComponent() != null && crm.getComponent().getImplementation() instanceof BPELComponentImplementationModel) {
            BPELComponentImplementationModel impl = (BPELComponentImplementationModel)crm.getComponent().getImplementation();
            QName processName = impl.getProcessQName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Register reference " + crm.getName() + " (" + crm.getQName() + ") for process " + processName));
            }
            if ((re = this._registry.get(processName)) == null) {
                re = new RegistryEntry();
                this._registry.put(processName, re);
            }
        } else {
            throw BPELMessages.MESSAGES.couldNotFindBPELImplementationAssociatedWithReference();
        }
        Definition wsdl = WSDLHelper.getWSDLDefinition(crm.getInterface().getInterface());
        PortType portType = WSDLHelper.getPortType(crm.getInterface().getInterface(), wsdl);
        re.register(portType, crm.getQName(), crm.getComponent().getQName());
    }

    public class ServiceProxy
    implements Service {
        private ServiceReference _serviceReference = null;
        private PortType _portType = null;

        public ServiceProxy(ServiceReference sref, PortType portType) {
            this._serviceReference = sref;
            this._portType = portType;
        }

        public Element invoke(String operationName, Element mesg, Map<String, Object> headers) throws Exception {
            Node node = WSDLHelper.unwrapMessagePart(mesg);
            SynchronousInOutHandler rh = new SynchronousInOutHandler();
            Exchange exchange = this._serviceReference.createExchange(operationName, (ExchangeHandler)rh);
            Message req = exchange.createMessage();
            req.setContent((Object)node);
            if (headers != null) {
                for (Map.Entry<String, Object> e : headers.entrySet()) {
                    exchange.getContext(req).setProperty(e.getKey(), headers.get(e.getKey())).addLabels(new String[]{EndpointLabel.SOAP.label()});
                }
                headers.clear();
            }
            exchange.send(req);
            Operation operation = this._portType.getOperation(operationName, null, null);
            Element newresp = null;
            Element respelem = null;
            if (ExchangePattern.IN_OUT.equals((Object)exchange.getContract().getConsumerOperation().getExchangePattern())) {
                try {
                    exchange = rh.waitForOut(RiftsawServiceLocator.this._waitTimeout);
                }
                catch (DeliveryException e) {
                    throw BPELMessages.MESSAGES.timedOutAfterMsWaitingOnSynchronousResponseFromTargetService(RiftsawServiceLocator.this._waitTimeout, this._serviceReference.getName().toString());
                }
                Message resp = exchange.getMessage();
                if (resp == null) {
                    throw BPELMessages.MESSAGES.responseNotReturnedFromOperationOnService(operationName, this._serviceReference.getName().toString());
                }
                for (Property p : exchange.getContext().getProperties(Scope.MESSAGE)) {
                    if (!p.hasLabel(EndpointLabel.SOAP.label())) continue;
                    headers.put(p.getName(), p.getValue());
                }
                if (resp.getContent() instanceof Exception && !(resp.getContent() instanceof BPELFault)) {
                    throw (Exception)resp.getContent();
                }
                respelem = (Element)resp.getContent(Node.class);
                newresp = WSDLHelper.wrapResponseMessagePart(respelem, operation);
            }
            if (exchange.getState() == ExchangeState.FAULT) {
                QName faultCode = null;
                if (respelem != null && respelem instanceof SOAPFault) {
                    SOAPFault fault = (SOAPFault)respelem;
                    respelem = (Element)fault.getDetail().getFirstChild();
                    faultCode = fault.getFaultCodeAsQName();
                }
                Element newfault = WSDLHelper.wrapFaultMessagePart(respelem, operation, null);
                throw new Fault(faultCode, newfault);
            }
            return newresp;
        }
    }

    public class RegistryEntry {
        private List<PortType> _portTypes = new Vector<PortType>();
        private List<QName> _services = new Vector<QName>();
        private QName _componentName;

        public void register(PortType portType, QName service, QName componentName) {
            this._portTypes.add(portType);
            this._services.add(service);
            this._componentName = componentName;
        }

        public Service getService(QName serviceName, String portName, ServiceDomain serviceDomain) {
            ServiceProxy ret = null;
            int count = this._services.size();
            for (int index = 0; index < count; ++index) {
                if (!serviceName.equals(this._services.get(index))) continue;
                QName refName = ComponentNames.qualify((QName)this._componentName, (QName)serviceName);
                ServiceReference sref = serviceDomain.getServiceReference(refName);
                if (sref == null) break;
                ret = new ServiceProxy(sref, this._portTypes.get(index));
                break;
            }
            if (ret == null) {
                BPELLogger.ROOT_LOGGER.noServiceFoundFor(serviceName.toString());
            }
            return ret;
        }
    }
}

