/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.deploy;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.component.bpm.config.model.BpmComponentImplementationModel;
import org.switchyard.component.bpm.exchange.BpmExchangeHandler;
import org.switchyard.component.bpm.exchange.BpmExchangeHandlerFactory;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.exception.SwitchYardException;

public class BpmActivator
extends BaseActivator {
    private Map<QName, BpmExchangeHandler> _handlers = new HashMap<QName, BpmExchangeHandler>();

    public BpmActivator() {
        super(new String[]{"bpm"});
    }

    public ExchangeHandler init(QName qname, Model model) {
        if (model instanceof ComponentServiceModel) {
            BpmExchangeHandler handler = BpmExchangeHandlerFactory.instance().newBpmExchangeHandler(this.getServiceDomain());
            BpmComponentImplementationModel bciModel = (BpmComponentImplementationModel)((ComponentServiceModel)model).getComponent().getImplementation();
            handler.init(qname, bciModel);
            this._handlers.put(qname, handler);
            return handler;
        }
        throw new SwitchYardException("No BPM component implementations found for service " + qname);
    }

    public void start(ServiceReference serviceRef) {
        BpmExchangeHandler handler = this._handlers.get(serviceRef.getName());
        if (handler != null) {
            handler.start(serviceRef);
        }
    }

    public void stop(ServiceReference serviceRef) {
        BpmExchangeHandler handler = this._handlers.get(serviceRef.getName());
        if (handler != null) {
            handler.stop(serviceRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(ServiceReference serviceRef) {
        BpmExchangeHandler handler = this._handlers.get(serviceRef.getName());
        if (handler != null) {
            try {
                handler.destroy(serviceRef);
            }
            finally {
                this._handlers.remove(serviceRef.getName());
            }
        }
    }
}

