/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.config.model.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.common.io.resource.SimpleResource;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.bpm.config.model.BPMComponentImplementationModel;
import org.switchyard.component.bpm.config.model.ParametersModel;
import org.switchyard.component.bpm.config.model.ProcessActionModel;
import org.switchyard.component.bpm.config.model.ResultsModel;
import org.switchyard.component.bpm.config.model.TaskHandlerModel;
import org.switchyard.component.common.rules.config.model.v1.V1ComponentImplementationModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V1BPMComponentImplementationModel
extends V1ComponentImplementationModel
implements BPMComponentImplementationModel {
    private List<ProcessActionModel> _processActions = new ArrayList<ProcessActionModel>();
    private List<TaskHandlerModel> _taskHandlers = new ArrayList<TaskHandlerModel>();
    private ParametersModel _parameters = null;
    private ResultsModel _results = null;

    public V1BPMComponentImplementationModel() {
        super("bpm", "urn:switchyard-component-bpm:config:1.0");
        this.setModelChildrenOrder(new String[]{"action", "audit", "eventListener", "taskHandler", "resource", "parameters", "results"});
    }

    public V1BPMComponentImplementationModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration processAction_config : config.getChildren("action")) {
            ProcessActionModel processAction = (ProcessActionModel)this.readModel(processAction_config);
            if (processAction == null) continue;
            this._processActions.add(processAction);
        }
        for (Configuration taskHandler_config : config.getChildren("taskHandler")) {
            TaskHandlerModel taskHandler = (TaskHandlerModel)this.readModel(taskHandler_config);
            if (taskHandler == null) continue;
            this._taskHandlers.add(taskHandler);
        }
        this.setModelChildrenOrder(new String[]{"action", "audit", "eventListener", "taskHandler", "resource", "parameters", "results"});
    }

    @Override
    public Resource getProcessDefinition() {
        String pd = this.getModelAttribute("processDefinition");
        if (pd != null) {
            String pdt = this.getModelAttribute("processDefinitionType");
            return new SimpleResource(pd, pdt != null ? ResourceType.valueOf((String)pdt) : null);
        }
        return null;
    }

    @Override
    public BPMComponentImplementationModel setProcessDefinition(Resource processDefinition) {
        this.setModelAttribute("processDefinition", processDefinition != null ? processDefinition.getLocation() : null);
        ResourceType pdt = processDefinition != null ? processDefinition.getType() : null;
        this.setModelAttribute("processDefinitionType", pdt != null ? pdt.getName() : null);
        return this;
    }

    @Override
    public String getProcessId() {
        return this.getModelAttribute("processId");
    }

    @Override
    public BPMComponentImplementationModel setProcessId(String processId) {
        this.setModelAttribute("processId", processId);
        return this;
    }

    @Override
    public boolean isPersistent() {
        String persistent = Strings.trimToNull((String)this.getModelAttribute("persistent"));
        if (persistent != null) {
            return Boolean.valueOf(persistent);
        }
        return false;
    }

    @Override
    public BPMComponentImplementationModel setPersistent(boolean persistent) {
        this.setModelAttribute("persistent", String.valueOf(persistent));
        return this;
    }

    @Override
    public Integer getSessionId() {
        String sessionId = this.getModelAttribute("sessionId");
        return sessionId != null ? Integer.valueOf(sessionId) : null;
    }

    @Override
    public BPMComponentImplementationModel setSessionId(Integer sessionId) {
        this.setModelAttribute("sessionId", sessionId != null ? sessionId.toString() : null);
        return this;
    }

    @Override
    public String getMessageContentInName() {
        return this.getModelAttribute("messageContentInName");
    }

    @Override
    public BPMComponentImplementationModel setMessageContentInName(String messageContentInName) {
        this.setModelAttribute("messageContentInName", messageContentInName);
        return this;
    }

    @Override
    public String getMessageContentOutName() {
        return this.getModelAttribute("messageContentOutName");
    }

    @Override
    public BPMComponentImplementationModel setMessageContentOutName(String messageContentOutName) {
        this.setModelAttribute("messageContentOutName", messageContentOutName);
        return this;
    }

    @Override
    public List<ProcessActionModel> getProcessActions() {
        return Collections.unmodifiableList(this._processActions);
    }

    @Override
    public BPMComponentImplementationModel addProcessAction(ProcessActionModel processAction) {
        this.addChildModel(processAction);
        this._processActions.add(processAction);
        return this;
    }

    @Override
    public List<TaskHandlerModel> getTaskHandlers() {
        return Collections.unmodifiableList(this._taskHandlers);
    }

    @Override
    public BPMComponentImplementationModel addTaskHandler(TaskHandlerModel taskHandler) {
        this.addChildModel(taskHandler);
        this._taskHandlers.add(taskHandler);
        return this;
    }

    @Override
    public ParametersModel getParameters() {
        if (this._parameters == null) {
            this._parameters = (ParametersModel)this.getFirstChildModel("parameters");
        }
        return this._parameters;
    }

    @Override
    public BPMComponentImplementationModel setParameters(ParametersModel parameters) {
        this.setChildModel(parameters);
        this._parameters = parameters;
        return this;
    }

    @Override
    public ResultsModel getResults() {
        if (this._results == null) {
            this._results = (ResultsModel)this.getFirstChildModel("results");
        }
        return this._results;
    }

    @Override
    public BPMComponentImplementationModel setResults(ResultsModel results) {
        this.setChildModel(results);
        this._results = results;
        return this;
    }
}

